/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.registry;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.objectweb.carol.jndi.registry.ManageableRegistry;
import org.objectweb.carol.jndi.registry.RegistryManager;

public class RegistryShell {
    private static Options cmdLineOptions = null;
    public static String HOST_LOCATION = "localhost";
    public static int PORT_NUMBER = 1099;

    public static void printHelp(Options cmdLineOptions) {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("Remot Proc Daemon Shell [options...]", cmdLineOptions);
    }

    public static void main(String[] args) {
        cmdLineOptions = new Options();
        cmdLineOptions.addOption('l', "host location", true, "Host location", false, false);
        cmdLineOptions.addOption('p', "port", true, "daemon rmi port number", false, false);
        cmdLineOptions.addOption('c', "command", true, "start a command and exit", false, false);
        cmdLineOptions.addOption('h', "help", false, "print this message and exit", false, false);
        CommandLine cmd = null;
        try {
            cmd = cmdLineOptions.parse(args, true);
        }
        catch (ParseException e) {
            System.err.println("\n" + e.getMessage());
            RegistryShell.printHelp(cmdLineOptions);
            System.err.println();
            System.exit(1);
        }
        if (cmd.hasOption('h')) {
            RegistryShell.printHelp(cmdLineOptions);
            System.exit(1);
        }
        if (cmd.hasOption('p')) {
            PORT_NUMBER = new Integer(cmd.getOptionValue('p'));
        }
        if (cmd.hasOption('l')) {
            HOST_LOCATION = cmd.getOptionValue('l');
        }
        if (cmd.hasOption('c')) {
            String procCmd = cmd.getOptionValue('c');
            RegistryShell.startCommandLine(procCmd);
            System.exit(0);
        }
        try {
            System.out.println("Connecting to Registry Manager: rmi://" + HOST_LOCATION + ":" + PORT_NUMBER);
            System.out.println("Start entering lines to manage remote processes");
            System.out.println("(use \"exit\" to exit)...");
            BufferedReader infile = new BufferedReader(new InputStreamReader(System.in));
            boolean cont = true;
            boolean fire = false;
            boolean write = false;
            System.out.print("reg> ");
            String line = infile.readLine();
            while (cont) {
                if (!line.equalsIgnoreCase("quit") && !line.equalsIgnoreCase("exit")) {
                    if (!fire) {
                        if (!line.equalsIgnoreCase("fw") && !line.equalsIgnoreCase("fr")) {
                            RegistryShell.startCommandLine(line);
                            System.out.print("reg> ");
                            line = infile.readLine();
                            continue;
                        }
                        fire = true;
                        if (line.equalsIgnoreCase("fw")) {
                            write = true;
                            continue;
                        }
                        write = false;
                        continue;
                    }
                    RegistryShell.startFireWallLine(line, write);
                    if (write) {
                        System.out.print("firewall w>");
                    } else {
                        System.out.print("firewall r>");
                    }
                    line = infile.readLine();
                    continue;
                }
                if (fire) {
                    fire = false;
                    System.out.print("\nreg> ");
                    line = infile.readLine();
                    continue;
                }
                cont = false;
            }
            System.out.println("ciao !");
            infile.close();
        }
        catch (Exception e) {
            System.err.println(e);
            return;
        }
    }

    public static void startCommandLine(String line) {
        block11: {
            try {
                if (line.trim().equals("")) break block11;
                if (line.trim().startsWith("help") || line.trim().startsWith("?")) {
                    RegistryShell.printHelpProcess();
                    break block11;
                }
                if (line.trim().startsWith("ping")) {
                    RegistryShell.printPing(line);
                    break block11;
                }
                if (line.trim().startsWith("v")) {
                    RegistryShell.printVerbose(line);
                    break block11;
                }
                if (line.trim().startsWith("purge")) {
                    RegistryShell.printPurge(line);
                    break block11;
                }
                if (line.trim().startsWith("list")) {
                    RegistryShell.printList(line);
                    break block11;
                }
                if (line.trim().startsWith("resume")) {
                    RegistryShell.printResumeRegistry();
                    break block11;
                }
                if (line.trim().startsWith("stop")) {
                    try {
                        RegistryShell.getRegistryManager().stop();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    System.out.println("registry stopped, get out of the shell");
                    System.exit(0);
                    break block11;
                }
                System.out.println("Unreconized function:" + line);
                RegistryShell.printHelpProcess();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void startFireWallLine(String line, boolean write) {
        block12: {
            try {
                if (line.trim().equals("") || line.equalsIgnoreCase("fw") || line.equalsIgnoreCase("fr")) break block12;
                if (line.trim().startsWith("help") || line.trim().startsWith("?")) {
                    RegistryShell.printFireWallHelpProcess();
                    break block12;
                }
                if (line.trim().startsWith("lista")) {
                    RegistryShell.printListAllowed(line, write);
                    break block12;
                }
                if (line.trim().startsWith("resume")) {
                    RegistryShell.printResumeFireWall();
                    break block12;
                }
                if (line.trim().startsWith("listf")) {
                    RegistryShell.printListForbiden(line, write);
                    break block12;
                }
                if (line.trim().startsWith("aaa")) {
                    RegistryShell.printAddAllow(line, write);
                    break block12;
                }
                if (line.trim().startsWith("afa")) {
                    RegistryShell.printAddForbid(line, write);
                    break block12;
                }
                if (line.trim().startsWith("aall")) {
                    RegistryShell.printAllowAll(line, write);
                    break block12;
                }
                if (line.trim().startsWith("fall")) {
                    RegistryShell.printForbidAll(line, write);
                    break block12;
                }
                if (line.trim().startsWith("is")) {
                    RegistryShell.printIsAllowed(line, write);
                    break block12;
                }
                if (line.trim().startsWith("isall")) {
                    RegistryShell.printIsAll(line, write);
                    break block12;
                }
                System.out.println("Unreconized function:" + line);
                RegistryShell.printHelpProcess();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void printIsAllowed(String line, boolean write) {
        block4: {
            try {
                StringTokenizer st = new StringTokenizer(line);
                if (st.countTokens() < 2) {
                    System.out.println("the isa function take a process name parametter:");
                    System.out.println("isa <IP>");
                    System.out.println("where <IP> is x.x.x.x");
                    break block4;
                }
                st.nextToken();
                String hostName = st.nextToken();
                byte[] ip = RegistryShell.getIP(hostName);
                if (write) {
                    System.out.println("Allow address for writing is: " + RegistryShell.getRegistryManager().isWriteAllow(Inet4Address.getByAddress(ip)));
                    break block4;
                }
                System.out.println("Allow address for reading is: " + RegistryShell.getRegistryManager().isReadAllow(Inet4Address.getByAddress(ip)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void printAddAllow(String line, boolean write) {
        block4: {
            try {
                StringTokenizer st = new StringTokenizer(line);
                if (st.countTokens() < 2) {
                    System.out.println("the aaa function take a process name parametter:");
                    System.out.println("aaa <IP>");
                    System.out.println("where <IP> is x.x.x.x");
                    break block4;
                }
                st.nextToken();
                String hostName = st.nextToken();
                byte[] ip = RegistryShell.getIP(hostName);
                if (write) {
                    RegistryShell.getRegistryManager().addWriteAllowAddress(Inet4Address.getByAddress(ip));
                    break block4;
                }
                RegistryShell.getRegistryManager().addReadAllowAddress(Inet4Address.getByAddress(ip));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void printAddForbid(String line, boolean write) {
        block4: {
            try {
                StringTokenizer st = new StringTokenizer(line);
                if (st.countTokens() < 2) {
                    System.out.println("the afa function take a process name parametter:");
                    System.out.println("afa <IP>");
                    System.out.println("where <IP> is x.x.x.x");
                    break block4;
                }
                st.nextToken();
                String hostName = st.nextToken();
                byte[] ip = RegistryShell.getIP(hostName);
                if (write) {
                    RegistryShell.getRegistryManager().addWriteForbidenAddress(Inet4Address.getByAddress(ip));
                    break block4;
                }
                RegistryShell.getRegistryManager().addReadForbidenAddress(Inet4Address.getByAddress(ip));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void printIsAll(String line, boolean write) {
        block3: {
            try {
                if (write) {
                    System.out.println("Allow address for writing is: " + RegistryShell.getRegistryManager().isWriteAllowAll());
                    break block3;
                }
                System.out.println("Allow address for reading is: " + RegistryShell.getRegistryManager().isReadAllowAll());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void printForbidAll(String line, boolean write) {
        block3: {
            try {
                if (write) {
                    RegistryShell.getRegistryManager().forbidWriteAll();
                    break block3;
                }
                RegistryShell.getRegistryManager().forbidReadAll();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void printAllowAll(String line, boolean write) {
        block3: {
            try {
                if (write) {
                    RegistryShell.getRegistryManager().allowWriteAll();
                    break block3;
                }
                RegistryShell.getRegistryManager().allowReadAll();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void printListForbiden(String line, boolean write) {
        try {
            if (write) {
                System.out.println("Forbiden Adresses for writing are");
                InetAddress[] fa = RegistryShell.getRegistryManager().listWriteForbidenAddress();
                int i = 0;
                while (i < fa.length) {
                    System.out.println(fa[i]);
                    ++i;
                }
            } else {
                System.out.println("Forbiden Adresses for reading are");
                InetAddress[] fa = RegistryShell.getRegistryManager().listReadForbidenAddress();
                int i = 0;
                while (i < fa.length) {
                    System.out.println(fa[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printListAllowed(String line, boolean write) {
        try {
            if (write) {
                System.out.println("Allowed Adresses for writing are");
                InetAddress[] fa = RegistryShell.getRegistryManager().listWriteAllowedAddress();
                int i = 0;
                while (i < fa.length) {
                    System.out.println(fa[i]);
                    ++i;
                }
            } else {
                System.out.println("Allowed Adresses for reading are");
                InetAddress[] fa = RegistryShell.getRegistryManager().listReadAllowedAddress();
                int i = 0;
                while (i < fa.length) {
                    System.out.println(fa[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printVerbose(String line) throws Exception {
        block3: {
            try {
                StringTokenizer st = new StringTokenizer(line);
                if (st.countTokens() < 2) {
                    System.out.println("the verbose function take a process name parametter:");
                    System.out.println("v <true|false>");
                    break block3;
                }
                st.nextToken();
                String verboseFlag = st.nextToken();
                RegistryShell.getRegistryManager().setVerbose(new Boolean(verboseFlag));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void printPing(String line) throws Exception {
        try {
            RegistryShell.getRegistryManager().ping();
            System.out.println("ping registry Ok");
        }
        catch (Exception e) {
            System.out.println("can not ping the registry");
        }
    }

    private static void printPurge(String line) throws Exception {
        try {
            RegistryShell.getRegistryManager().purge();
            System.out.println("registry purged");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printList(String line) throws Exception {
        try {
            String[] list = RegistryShell.getRegistryManager().list();
            System.out.println("registry list:");
            int i = 0;
            while (i < list.length) {
                System.out.println(list[i]);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static byte[] getIP(String hostName) {
        if (hostName.length() == 0) {
            return null;
        }
        byte[] dst = new byte[4];
        char[] srcb = hostName.toCharArray();
        boolean saw_digit = false;
        int octets = 0;
        int i = 0;
        int cur = 0;
        while (i < srcb.length) {
            char ch;
            if (Character.isDigit(ch = srcb[i++])) {
                int sum = dst[cur] * 10 + (Character.digit(ch, 10) & 0xFF);
                if (sum > 255) {
                    return null;
                }
                dst[cur] = (byte)(sum & 0xFF);
                if (saw_digit) continue;
                if (++octets > 4) {
                    return null;
                }
                saw_digit = true;
                continue;
            }
            if (ch == '.' && saw_digit) {
                if (octets == 4) {
                    return null;
                }
                dst[++cur] = 0;
                saw_digit = false;
                continue;
            }
            return null;
        }
        if (octets < 4) {
            return null;
        }
        return dst;
    }

    private static void printResumeRegistry() {
        try {
            System.out.println("Registry Resume:");
            System.out.println("Started on host: " + HOST_LOCATION + " and on port: " + PORT_NUMBER);
            System.out.println("Objects binded:");
            String[] list = RegistryShell.getRegistryManager().list();
            int i = 0;
            while (i < list.length) {
                System.out.println(list[i]);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printResumeFireWall() {
        try {
            int i;
            InetAddress[] fa;
            System.out.println("FireWall Resume:");
            if (RegistryShell.getRegistryManager().isReadAllowAll()) {
                System.out.println("Read access is allow for all IP except:");
                fa = RegistryShell.getRegistryManager().listReadForbidenAddress();
                i = 0;
                while (i < fa.length) {
                    System.out.println(fa[i]);
                    ++i;
                }
            } else {
                System.out.println("Read access is forbiden for all IP except:");
                fa = RegistryShell.getRegistryManager().listReadAllowedAddress();
                i = 0;
                while (i < fa.length) {
                    System.out.println(fa[i]);
                    ++i;
                }
            }
            if (RegistryShell.getRegistryManager().isWriteAllowAll()) {
                System.out.println("Write access is allow for all IP except:");
                fa = RegistryShell.getRegistryManager().listWriteForbidenAddress();
                i = 0;
                while (i < fa.length) {
                    System.out.println(fa[i]);
                    ++i;
                }
            } else {
                System.out.println("Write access is forbiden for all IP except:");
                fa = RegistryShell.getRegistryManager().listWriteAllowedAddress();
                i = 0;
                while (i < fa.length) {
                    System.out.println(fa[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static RegistryManager getRegistryManager() {
        Properties iprop = new Properties();
        iprop.put("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
        iprop.put("java.naming.provider.url", "rmi://" + HOST_LOCATION + ":" + PORT_NUMBER);
        try {
            InitialContext in = new InitialContext(iprop);
            return (RegistryManager)in.lookup(ManageableRegistry.REGISTRY_MANAGER_NAME);
        }
        catch (Exception e) {
            System.out.println("Can not start shell, can not contact Registry Manager" + e);
            return null;
        }
    }

    public static void printHelpProcess() {
        System.out.println("Registry Manager shell commands (reg>):");
        System.out.println("help or ?\t\t\t\t\t-> print this help");
        System.out.println("exit\t\t\t\t\t\t-> exit of this shell");
        System.out.println("ping\t\t\t\t\t\t-> ping the registry");
        System.out.println("stop\t\t\t\t\t\t-> stop the registry");
        System.out.println("resume\t\t\t\t\t-> resume the registry");
        System.out.println("v\t<true|false>\t\t-> set the verbose flag");
        System.out.println("purge\t\t\t\t\t\t-> purge the registry");
        System.out.println("list\t\t\t\t\t\t\t-> list the registry");
        System.out.println("fw <command>\t\t-> write firewal shell");
        System.out.println("fr <command>\t\t-> write firewal shell");
    }

    public static void printFireWallHelpProcess() {
        System.out.println("The firewalls shell commands are: (firewall r/w>");
        System.out.println("IP address are IPV4 address: x.x.x.x");
        System.out.println("exit\t \t\t\t\t\t-> return to root shell");
        System.out.println("resume\t\t\t\t\t-> resume the firewall");
        System.out.println("lista\t\t\t\t\t\t-> list allowed ip address");
        System.out.println("listf\t\t\t\t\t\t-> list forbiden ip address");
        System.out.println("aaa <IP>\t\t\t    -> add allowed ip address");
        System.out.println("afa\t<IP>\t\t    \t-> add forbiden ip address");
        System.out.println("aall\t\t\t    \t\t\t-> allowed all ip address");
        System.out.println("fall <IP>\t\t\t    \t-> forbid all ip address");
        System.out.println("is <IP>\t\t\t\t\t-> is allow for this ip address");
        System.out.println("isall\t\t\t    \t\t-> is allowed all ip address");
    }
}

