/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.SourceFileScanner;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UpToDate
extends Task
implements Condition {
    private String _property;
    private String _value;
    private File _sourceFile;
    private File _targetFile;
    private Vector sourceFileSets;
    protected Mapper mapperElement;

    public void setProperty(String string) {
        this._property = string;
    }

    public void setValue(String string) {
        this._value = string;
    }

    private final String getValue() {
        return this._value != null ? this._value : "true";
    }

    public void setTargetFile(File file) {
        this._targetFile = file;
    }

    public void setSrcfile(File file) {
        this._sourceFile = file;
    }

    public void addSrcfiles(FileSet fileSet) {
        this.sourceFileSets.addElement(fileSet);
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    public boolean eval() {
        Object object;
        if (this.sourceFileSets.size() == 0 && this._sourceFile == null) {
            throw new BuildException("At least one srcfile or a nested <srcfiles> element must be set.");
        }
        if (this.sourceFileSets.size() > 0 && this._sourceFile != null) {
            throw new BuildException("Cannot specify both the srcfile attribute and a nested <srcfiles> element.");
        }
        if (this._targetFile == null && this.mapperElement == null) {
            throw new BuildException("The targetfile attribute or a nested mapper element must be set.");
        }
        if (this._targetFile != null && !this._targetFile.exists()) {
            this.log("The targetfile \"" + this._targetFile.getAbsolutePath() + "\" does not exist.", 3);
            return false;
        }
        if (this._sourceFile != null && !this._sourceFile.exists()) {
            throw new BuildException(this._sourceFile.getAbsolutePath() + " not found.");
        }
        Enumeration enumeration = this.sourceFileSets.elements();
        boolean bl = true;
        while (bl && enumeration.hasMoreElements()) {
            object = (FileSet)enumeration.nextElement();
            DirectoryScanner directoryScanner = ((AbstractFileSet)object).getDirectoryScanner(this.getProject());
            boolean bl2 = false;
            if (!bl || !this.scanDir(((AbstractFileSet)object).getDir(this.getProject()), directoryScanner.getIncludedFiles())) continue;
            bl2 = bl = true;
        }
        if (this._sourceFile != null) {
            if (this.mapperElement == null) {
                boolean bl3 = false;
                if (bl && this._targetFile.lastModified() >= this._sourceFile.lastModified()) {
                    bl3 = true;
                }
                bl = bl3;
            } else {
                object = new SourceFileScanner(this);
                boolean bl4 = false;
                if (bl && ((SourceFileScanner)object).restrict(new String[]{this._sourceFile.getAbsolutePath()}, null, null, this.mapperElement.getImplementation()).length == 0) {
                    bl4 = true;
                }
                bl = bl4;
            }
        }
        return bl;
    }

    public void execute() throws BuildException {
        if (this._property == null) {
            throw new BuildException("property attribute is required.", this.getLocation());
        }
        boolean bl = this.eval();
        if (bl) {
            this.getProject().setNewProperty(this._property, this.getValue());
            if (this.mapperElement == null) {
                this.log("File \"" + this._targetFile.getAbsolutePath() + "\" is up-to-date.", 3);
            } else {
                this.log("All target files are up-to-date.", 3);
            }
        }
    }

    protected boolean scanDir(File file, String[] stringArray) {
        SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
        FileNameMapper fileNameMapper = null;
        File file2 = file;
        if (this.mapperElement == null) {
            MergingMapper mergingMapper = new MergingMapper();
            mergingMapper.setTo(this._targetFile.getAbsolutePath());
            fileNameMapper = mergingMapper;
            file2 = null;
        } else {
            fileNameMapper = this.mapperElement.getImplementation();
        }
        boolean bl = false;
        if (sourceFileScanner.restrict(stringArray, file, file2, fileNameMapper).length == 0) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.sourceFileSets = new Vector();
        this.mapperElement = null;
    }

    public UpToDate() {
        this.this();
    }
}

