/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.CRC32;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.ZipScanner;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.ResourceUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Zip
extends MatchingTask {
    private static final long EMPTY_CRC = new CRC32().getValue();
    private static FileUtils fileUtils = FileUtils.newFileUtils();
    protected File zipFile;
    private ZipScanner zs;
    private File baseDir;
    protected Hashtable entries;
    private Vector groupfilesets;
    private Vector filesetsFromGroupfilesets;
    protected String duplicate;
    private boolean doCompress;
    private boolean doUpdate;
    private boolean savedDoUpdate;
    private boolean doFilesonly;
    protected String archiveType;
    protected String emptyBehavior;
    private Vector filesets;
    protected Hashtable addedDirs;
    private Vector addedFiles;
    protected boolean doubleFilePass;
    protected boolean skipWriting;
    private boolean addingNewFiles;
    private String encoding;
    private boolean keepCompression;
    private boolean roundUp;

    public void setZipfile(File file) {
        this.setDestFile(file);
    }

    public void setFile(File file) {
        this.setDestFile(file);
    }

    public void setDestFile(File file) {
        this.zipFile = file;
    }

    public File getDestFile() {
        return this.zipFile;
    }

    public void setBasedir(File file) {
        this.baseDir = file;
    }

    public void setCompress(boolean bl) {
        this.doCompress = bl;
    }

    public boolean isCompress() {
        return this.doCompress;
    }

    public void setFilesonly(boolean bl) {
        this.doFilesonly = bl;
    }

    public void setUpdate(boolean bl) {
        this.doUpdate = bl;
        this.savedDoUpdate = bl;
    }

    public boolean isInUpdateMode() {
        return this.doUpdate;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void addZipfileset(ZipFileSet zipFileSet) {
        this.filesets.addElement(zipFileSet);
    }

    public void addZipGroupFileset(FileSet fileSet) {
        this.groupfilesets.addElement(fileSet);
    }

    public void setDuplicate(Duplicate duplicate) {
        this.duplicate = duplicate.getValue();
    }

    public void setWhenempty(WhenEmpty whenEmpty) {
        this.emptyBehavior = whenEmpty.getValue();
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setKeepCompression(boolean bl) {
        this.keepCompression = bl;
    }

    public void setRoundUp(boolean bl) {
        this.roundUp = bl;
    }

    public void execute() throws BuildException {
        if (this.doubleFilePass) {
            this.skipWriting = true;
            this.executeMain();
            this.skipWriting = false;
            this.executeMain();
        } else {
            this.executeMain();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeMain() throws BuildException {
        if (this.baseDir == null && this.filesets.size() == 0 && this.groupfilesets.size() == 0 && "zip".equals(this.archiveType)) {
            throw new BuildException("basedir attribute must be set, or at least one fileset must be given!");
        }
        if (this.zipFile == null) {
            throw new BuildException("You must specify the " + this.archiveType + " file to create!");
        }
        if (this.zipFile.exists() && !this.zipFile.isFile()) {
            throw new BuildException(this.zipFile + " is not a file.");
        }
        if (this.zipFile.exists() && !this.zipFile.canWrite()) {
            throw new BuildException(this.zipFile + " is read-only.");
        }
        var1_1 = null;
        this.addingNewFiles = true;
        if (this.doUpdate && !this.zipFile.exists()) {
            this.doUpdate = false;
            this.log("ignoring update attribute as " + this.archiveType + " doesn't exist.", 4);
        }
        var2_2 = 0;
        block16: while (true) {
            if (var2_2 >= this.groupfilesets.size()) {
                var2_3 = new Vector<Object>();
                if (this.baseDir != null) {
                    var3_4 = (FileSet)this.getImplicitFileSet().clone();
                    var3_4.setDir(this.baseDir);
                    var2_3.addElement(var3_4);
                }
                break;
            }
            this.log("Processing groupfileset ", 3);
            var3_4 = (FileSet)this.groupfilesets.elementAt(var2_2);
            var4_7 = var3_4.getDirectoryScanner(this.getProject());
            var5_9 = var4_7.getIncludedFiles();
            var6_11 = var4_7.getBasedir();
            var7_12 = 0;
            while (true) {
                if (var7_12 >= var5_9.length) {
                    ++var2_2;
                    continue block16;
                }
                this.log("Adding file " + var5_9[var7_12] + " to fileset", 3);
                var8_15 = new ZipFileSet();
                var8_15.setProject(this.getProject());
                var8_15.setSrc(new File(var6_11, var5_9[var7_12]));
                this.filesets.addElement(var8_15);
                this.filesetsFromGroupfilesets.addElement(var8_15);
                ++var7_12;
            }
            break;
        }
        var3_5 = 0;
        while (true) {
            if (var3_5 >= this.filesets.size()) {
                var3_6 = new FileSet[var2_3.size()];
                var2_3.copyInto(var3_6);
                var4_8 = false;
                ** try [egrp 0[TRYBLOCK] [9 : 507->1334)] { 
lbl49:
                // 1 sources

                break;
            }
            var4_7 = (FileSet)this.filesets.elementAt(var3_5);
            var2_3.addElement(var4_7);
            ++var3_5;
        }
        {
            try {
                var7_13 = this.getResourcesToAdd((FileSet[])var3_6, this.zipFile, false);
                if (!var7_13.isOutOfDate()) {
                    var6_11 = null;
                    this.cleanUp();
                    return;
                }
                var8_15 = var7_13.getResourcesToAdd();
                if (this.doUpdate) {
                    var1_1 = Zip.fileUtils.createTempFile("zip", ".tmp", Zip.fileUtils.getParentFile(this.zipFile));
                    var1_1.deleteOnExit();
                    try {
                        Zip.fileUtils.rename(this.zipFile, var1_1);
                    }
                    catch (SecurityException var9_16) {
                        throw new BuildException("Not allowed to rename old file (" + this.zipFile.getAbsolutePath() + ") to temporary file");
                    }
                    catch (IOException var9_17) {
                        throw new BuildException("Unable to rename old file (" + this.zipFile.getAbsolutePath() + ") to temporary file");
                    }
                }
                var9_18 = this.doUpdate != false ? "Updating " : "Building ";
                this.log(var9_18 + this.archiveType + ": " + this.zipFile.getAbsolutePath());
                var10_20 = null;
                try {
                    block47: {
                        block48: {
                            if (!this.skipWriting) {
                                var10_20 = new ZipOutputStream(this.zipFile);
                                var10_20.setEncoding(this.encoding);
                                if (this.doCompress) {
                                    var10_20.setMethod(8);
                                } else {
                                    var10_20.setMethod(0);
                                }
                            }
                            this.initZipOutputStream(var10_20);
                            var14_21 = 0;
                            while (true) {
                                if (var14_21 >= var3_6.length) {
                                    if (this.doUpdate) {
                                        break;
                                    }
                                    break block47;
                                }
                                if (((Object)var8_15[var14_21]).length != 0) {
                                    this.addResources((FileSet)var3_6[var14_21], (Resource[])var8_15[var14_21], var10_20);
                                }
                                ++var14_21;
                            }
                            this.addingNewFiles = false;
                            var14_22 = new ZipFileSet();
                            var14_22.setProject(this.getProject());
                            var14_22.setSrc(var1_1);
                            var15_23 = 0;
                            while (true) {
                                if (var15_23 >= this.addedFiles.size()) break;
                                var16_25 = var14_22.createExclude();
                                var16_25.setName((String)this.addedFiles.elementAt(var15_23));
                                ++var15_23;
                            }
                            var15_24 = var14_22.getDirectoryScanner(this.getProject());
                            ((ZipScanner)var15_24).setEncoding(this.encoding);
                            var16_25 = var15_24.getIncludedFiles();
                            var17_26 = new Resource[var16_25.length];
                            var18_27 = 0;
                            while (true) {
                                if (var18_27 >= var16_25.length) {
                                    if (!this.doFilesonly) {
                                        break;
                                    }
                                    break block48;
                                }
                                var17_26[var18_27] = var15_24.getResource(var16_25[var18_27]);
                                ++var18_27;
                            }
                            var18_28 = var15_24.getIncludedDirectories();
                            var19_29 = new Resource[var18_28.length];
                            var20_30 = 0;
                            while (true) {
                                if (var20_30 >= var18_28.length) {
                                    var20_31 = var17_26;
                                    var17_26 = new Resource[var20_31.length + var19_29.length];
                                    System.arraycopy(var19_29, 0, var17_26, 0, var19_29.length);
                                    System.arraycopy(var20_31, 0, var17_26, var19_29.length, var20_31.length);
                                    break;
                                }
                                var19_29[var20_30] = var15_24.getResource(var18_28[var20_30]);
                                ++var20_30;
                            }
                        }
                        this.addResources(var14_22, var17_26, var10_20);
                    }
                    this.finalizeZipOutputStream(var10_20);
                    if (this.doUpdate && !var1_1.delete()) {
                        this.log("Warning: unable to delete temporary file " + var1_1.getName(), 1);
                    }
                    var4_8 = true;
                }
                catch (Throwable var11_32) {
                    var12_33 = null;
                    try {
                        if (var10_20 == null) throw var11_32;
                        var10_20.close();
                        throw var11_32;
                    }
                    catch (IOException var13_35) {
                        if (var4_8 == false) throw var11_32;
                        throw var13_35;
                    }
                }
                {
                    var12_34 = null;
                }
                try {}
                catch (IOException var13_36) {
                    if (var4_8) {
                        throw var13_36;
                    }
                    ** GOTO lbl-1000
                }
                if (var10_20 != null) {
                    var10_20.close();
                }
                ** GOTO lbl-1000
            }
            catch (IOException var7_14) {
                var8_15 = "Problem creating " + this.archiveType + ": " + var7_14.getMessage();
                if (!(this.doUpdate && var1_1 == null || this.zipFile.delete())) {
                    var8_15 = (String)var8_15 + " (and the archive is probably corrupt but I could not delete it)";
                }
                if (this.doUpdate == false) throw new BuildException((String)var8_15, var7_14, this.getLocation());
                if (var1_1 == null) throw new BuildException((String)var8_15, var7_14, this.getLocation());
                try {
                    Zip.fileUtils.rename(var1_1, this.zipFile);
                    throw new BuildException((String)var8_15, var7_14, this.getLocation());
                }
                catch (IOException var9_19) {
                    var8_15 = (String)var8_15 + " (and I couldn't rename the temporary file " + var1_1.getName() + " back)";
                }
                throw new BuildException((String)var8_15, var7_14, this.getLocation());
            }
        }
lbl170:
        // 1 sources

        catch (Throwable var5_10) {
            var6_11 = null;
            this.cleanUp();
            throw var5_10;
        }
lbl-1000:
        // 2 sources

        {
            var6_11 = null;
            this.cleanUp();
            return;
        }
    }

    protected final boolean isAddingNewFiles() {
        return this.addingNewFiles;
    }

    /*
     * Exception decompiling
     */
    protected final void addResources(FileSet var1_1, Resource[] var2_2, ZipOutputStream var3_3) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 691->694)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void initZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
    }

    protected void finalizeZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
    }

    /*
     * Exception decompiling
     */
    protected boolean createEmptyZip(File var1_1) throws BuildException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 148->151)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final synchronized ZipScanner getZipScanner() {
        if (this.zs == null) {
            this.zs = new ZipScanner();
            this.zs.setEncoding(this.encoding);
            this.zs.setSrc(this.zipFile);
        }
        return this.zs;
    }

    protected ArchiveState getResourcesToAdd(FileSet[] fileSetArray, File file, boolean bl) throws BuildException {
        Object object;
        Object object2;
        Resource[][] resourceArray = this.grabResources(fileSetArray);
        if (Zip.isEmpty(resourceArray)) {
            if (bl && this.doUpdate) {
                return new ArchiveState(true, resourceArray);
            }
            if (this.emptyBehavior.equals("skip")) {
                if (this.doUpdate) {
                    this.log(this.archiveType + " archive " + file + " not updated because no new files were included.", 3);
                } else {
                    this.log("Warning: skipping " + this.archiveType + " archive " + file + " because no files were included.", 1);
                }
            } else {
                if (this.emptyBehavior.equals("fail")) {
                    throw new BuildException("Cannot create " + this.archiveType + " archive " + file + ": no files were included.", this.getLocation());
                }
                this.createEmptyZip(file);
            }
            return new ArchiveState(bl, resourceArray);
        }
        if (!file.exists()) {
            return new ArchiveState(true, resourceArray);
        }
        if (bl && !this.doUpdate) {
            return new ArchiveState(true, resourceArray);
        }
        Resource[][] resourceArray2 = new Resource[fileSetArray.length][];
        int n = 0;
        while (n < fileSetArray.length) {
            if (!(this.fileset instanceof ZipFileSet) || ((ZipFileSet)this.fileset).getSrc(this.getProject()) == null) {
                object2 = fileSetArray[n].getDir(this.getProject());
                int n2 = 0;
                while (n2 < resourceArray[n].length) {
                    object = fileUtils.resolveFile((File)object2, resourceArray[n][n2].getName());
                    if (((File)object).equals(file)) {
                        throw new BuildException("A zip file cannot include itself", this.getLocation());
                    }
                    ++n2;
                }
            }
            ++n;
        }
        n = 0;
        while (n < fileSetArray.length) {
            if (resourceArray[n].length == 0) {
                resourceArray2[n] = new Resource[0];
            } else {
                object2 = new IdentityMapper();
                if (fileSetArray[n] instanceof ZipFileSet) {
                    ZipFileSet zipFileSet = (ZipFileSet)fileSetArray[n];
                    if (zipFileSet.getFullpath(this.getProject()) != null && !zipFileSet.getFullpath(this.getProject()).equals("")) {
                        object = new MergingMapper();
                        ((MergingMapper)object).setTo(zipFileSet.getFullpath(this.getProject()));
                        object2 = object;
                    } else if (zipFileSet.getPrefix(this.getProject()) != null && !zipFileSet.getPrefix(this.getProject()).equals("")) {
                        object = new GlobPatternMapper();
                        ((GlobPatternMapper)object).setFrom("*");
                        String string = zipFileSet.getPrefix(this.getProject());
                        if (!string.endsWith("/") && !string.endsWith("\\")) {
                            string = string + '/';
                        }
                        ((GlobPatternMapper)object).setTo(string + '*');
                        object2 = object;
                    }
                }
                Resource[] resourceArray3 = resourceArray[n];
                if (this.doFilesonly) {
                    resourceArray3 = this.selectFileResources(resourceArray3);
                }
                resourceArray2[n] = ResourceUtils.selectOutOfDateSources(this, resourceArray3, (FileNameMapper)object2, this.getZipScanner());
                boolean bl2 = false;
                if (bl || resourceArray2[n].length > 0) {
                    bl2 = true;
                }
                if ((bl = bl2) && !this.doUpdate) break;
            }
            ++n;
        }
        if (bl && !this.doUpdate) {
            return new ArchiveState(true, resourceArray);
        }
        return new ArchiveState(bl, resourceArray2);
    }

    protected Resource[][] grabResources(FileSet[] fileSetArray) {
        Resource[][] resourceArray = new Resource[fileSetArray.length][];
        int n = 0;
        while (n < fileSetArray.length) {
            Object object;
            boolean bl = true;
            if (fileSetArray[n] instanceof ZipFileSet) {
                object = (ZipFileSet)fileSetArray[n];
                boolean bl2 = false;
                if (((ZipFileSet)object).getPrefix(this.getProject()).equals("") && ((ZipFileSet)object).getFullpath(this.getProject()).equals("")) {
                    bl2 = bl = true;
                }
            }
            if ((object = fileSetArray[n].getDirectoryScanner(this.getProject())) instanceof ZipScanner) {
                ((ZipScanner)object).setEncoding(this.encoding);
            }
            Vector<Resource> vector = new Vector<Resource>();
            String[] stringArray = ((DirectoryScanner)object).getIncludedDirectories();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (!"".equals(stringArray[0]) || !bl) {
                    vector.addElement(((DirectoryScanner)object).getResource(stringArray[n2]));
                }
                ++n2;
            }
            String[] stringArray2 = ((DirectoryScanner)object).getIncludedFiles();
            int n3 = 0;
            while (n3 < stringArray2.length) {
                if (!"".equals(stringArray2[0]) || !bl) {
                    vector.addElement(((DirectoryScanner)object).getResource(stringArray2[n3]));
                }
                ++n3;
            }
            resourceArray[n] = new Resource[vector.size()];
            vector.copyInto(resourceArray[n]);
            ++n;
        }
        return resourceArray;
    }

    protected void zipDir(File file, ZipOutputStream zipOutputStream, String string, int n) throws IOException {
        if (this.addedDirs.get(string) != null) {
            return;
        }
        this.log("adding directory " + string, 3);
        this.addedDirs.put(string, string);
        if (!this.skipWriting) {
            ZipEntry zipEntry = new ZipEntry(string);
            if (file != null && file.exists()) {
                zipEntry.setTime(file.lastModified() + (long)(this.roundUp ? 1999 : 0));
            } else {
                zipEntry.setTime(System.currentTimeMillis() + (long)(this.roundUp ? 1999 : 0));
            }
            zipEntry.setSize(0L);
            zipEntry.setMethod(0);
            zipEntry.setCrc(EMPTY_CRC);
            zipEntry.setUnixMode(n);
            zipOutputStream.putNextEntry(zipEntry);
        }
    }

    protected void zipFile(InputStream inputStream, ZipOutputStream zipOutputStream, String string, long l, File file, int n) throws IOException {
        if (this.entries.contains(string)) {
            if (this.duplicate.equals("preserve")) {
                this.log(string + " already added, skipping", 2);
                return;
            }
            if (this.duplicate.equals("fail")) {
                throw new BuildException("Duplicate file " + string + " was found and the duplicate attribute is 'fail'.");
            }
            this.log("duplicate file " + string + " found, adding.", 3);
        } else {
            this.log("adding entry " + string, 3);
        }
        this.entries.put(string, string);
        if (!this.skipWriting) {
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setTime(l);
            zipEntry.setMethod(this.doCompress ? 8 : 0);
            if (!zipOutputStream.isSeekable() && !this.doCompress) {
                Object object;
                long l2 = 0L;
                CRC32 cRC32 = new CRC32();
                if (!inputStream.markSupported()) {
                    object = new ByteArrayOutputStream();
                    byte[] byArray = new byte[8192];
                    int n2 = 0;
                    do {
                        l2 += (long)n2;
                        cRC32.update(byArray, 0, n2);
                        ((ByteArrayOutputStream)object).write(byArray, 0, n2);
                    } while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1);
                    inputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
                } else {
                    inputStream.mark(Integer.MAX_VALUE);
                    object = new byte[8192];
                    int n3 = 0;
                    do {
                        l2 += (long)n3;
                        cRC32.update((byte[])object, 0, n3);
                    } while ((n3 = inputStream.read((byte[])object, 0, ((Object)object).length)) != -1);
                    inputStream.reset();
                }
                zipEntry.setSize(l2);
                zipEntry.setCrc(cRC32.getValue());
            }
            zipEntry.setUnixMode(n);
            zipOutputStream.putNextEntry(zipEntry);
            byte[] byArray = new byte[8192];
            int n4 = 0;
            do {
                if (n4 == 0) continue;
                zipOutputStream.write(byArray, 0, n4);
            } while ((n4 = inputStream.read(byArray, 0, byArray.length)) != -1);
        }
        this.addedFiles.addElement(string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void zipFile(File file, ZipOutputStream zipOutputStream, String string, int n) throws IOException {
        if (file.equals(this.zipFile)) {
            throw new BuildException("A zip file cannot include itself", this.getLocation());
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.zipFile(fileInputStream, zipOutputStream, string, file.lastModified() + (long)(this.roundUp ? 1999 : 0), null, n);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            fileInputStream.close();
            throw throwable;
        }
        {
            Object var7_8 = null;
        }
        fileInputStream.close();
    }

    protected final void addParentDirs(File file, String string, ZipOutputStream zipOutputStream, String string2, int n) throws IOException {
        if (!this.doFilesonly) {
            String string3;
            Stack<String> stack = new Stack<String>();
            int n2 = string.length();
            while ((n2 = string.lastIndexOf(47, n2 - 1)) != -1) {
                string3 = string.substring(0, n2 + 1);
                if (this.addedDirs.get(string2 + string3) != null) break;
                stack.push(string3);
            }
            while (!stack.isEmpty()) {
                string3 = (String)stack.pop();
                File file2 = null;
                file2 = file != null ? new File(file, string3) : new File(string3);
                this.zipDir(file2, zipOutputStream, string2 + string3, n);
            }
        }
    }

    protected void cleanUp() {
        this.addedDirs.clear();
        this.addedFiles.removeAllElements();
        this.entries.clear();
        this.addingNewFiles = false;
        this.doUpdate = this.savedDoUpdate;
        Enumeration enumeration = this.filesetsFromGroupfilesets.elements();
        while (enumeration.hasMoreElements()) {
            ZipFileSet zipFileSet = (ZipFileSet)enumeration.nextElement();
            this.filesets.removeElement(zipFileSet);
        }
        this.filesetsFromGroupfilesets.removeAllElements();
    }

    public void reset() {
        this.filesets.removeAllElements();
        this.zipFile = null;
        this.baseDir = null;
        this.groupfilesets.removeAllElements();
        this.duplicate = "add";
        this.archiveType = "zip";
        this.doCompress = true;
        this.emptyBehavior = "skip";
        this.doUpdate = false;
        this.doFilesonly = false;
        this.encoding = null;
    }

    protected static final boolean isEmpty(Resource[][] resourceArray) {
        int n = 0;
        while (n < resourceArray.length) {
            if (resourceArray[n].length > 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected Resource[] selectFileResources(Resource[] resourceArray) {
        if (resourceArray.length == 0) {
            return resourceArray;
        }
        Vector<Resource> vector = new Vector<Resource>(resourceArray.length);
        int n = 0;
        while (n < resourceArray.length) {
            if (!resourceArray[n].isDirectory()) {
                vector.addElement(resourceArray[n]);
            } else {
                this.log("Ignoring directory " + resourceArray[n].getName() + " as only files will be added.", 3);
            }
            ++n;
        }
        if (vector.size() != resourceArray.length) {
            Object[] objectArray = new Resource[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return resourceArray;
    }

    private final /* synthetic */ void this() {
        this.entries = new Hashtable();
        this.groupfilesets = new Vector();
        this.filesetsFromGroupfilesets = new Vector();
        this.duplicate = "add";
        this.doCompress = true;
        this.doUpdate = false;
        this.savedDoUpdate = false;
        this.doFilesonly = false;
        this.archiveType = "zip";
        this.emptyBehavior = "skip";
        this.filesets = new Vector();
        this.addedDirs = new Hashtable();
        this.addedFiles = new Vector();
        this.doubleFilePass = false;
        this.skipWriting = false;
        this.addingNewFiles = false;
        this.keepCompression = false;
        this.roundUp = true;
    }

    public Zip() {
        this.this();
    }

    public static class Duplicate
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"add", "preserve", "fail"};
        }
    }

    public static class WhenEmpty
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"fail", "skip", "create"};
        }
    }

    public static class ArchiveState {
        private boolean outOfDate;
        private Resource[][] resourcesToAdd;

        public boolean isOutOfDate() {
            return this.outOfDate;
        }

        public Resource[][] getResourcesToAdd() {
            return this.resourcesToAdd;
        }

        ArchiveState(boolean bl, Resource[][] resourceArray) {
            this.outOfDate = bl;
            this.resourcesToAdd = resourceArray;
        }
    }
}

