/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet.jsr77;

import javax.management.j2ee.statistics.TimeStatistic;
import org.mortbay.jetty.servlet.jsr77.ServletStatsImpl;

public class TimeStatisticImpl
implements TimeStatistic {
    private static final String HOUR = "HOUR";
    private static final String MICROSECOND = "MICROSECOND";
    private static final String MILLISECONDS = "MILLISECONDS";
    private static final String MINUTE = "MINUTE";
    private static final String NANOSECOND = "NANOSECOND";
    private static final String SECOND = "SECOND";
    private ServletStatsImpl servletStats = null;
    private long count = 0L;
    private long maxTime = 0L;
    private long minTime = 0L;
    private long totalTime = 0L;
    private long startTime = 0L;
    private long lastSampleTime = 0L;
    private String name = null;
    private String description = null;
    private String units = null;

    public TimeStatisticImpl(ServletStatsImpl servletStats, String name, String description, String unit) {
        this.setServletStats(servletStats);
        this.setName(name);
        this.setDescription(description);
        this.setUnit(unit);
    }

    public long getCount() {
        return this.count;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getUnit() {
        return this.units;
    }

    public void setUnit(String u) {
        this.units = u;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    public long getLastSampleTime() {
        return this.lastSampleTime;
    }

    public void setServletStats(ServletStatsImpl stats) {
        this.servletStats = stats;
    }

    public synchronized void addSample(long sample, long time) {
        ++this.count;
        if (sample > this.maxTime) {
            this.maxTime = sample;
        }
        if (sample < this.minTime || this.minTime == 0L) {
            this.minTime = sample;
        }
        this.lastSampleTime = time;
        this.totalTime += sample;
    }

    public String toString() {
        return "Name=" + this.getName() + ", Description=" + this.getDescription() + ", Units=" + this.getUnit() + ", StartTime=" + this.getStartTime() + ", Count=" + this.getCount() + ", MinTime=" + this.getMinTime() + ", MaxTime=" + this.getMaxTime() + ", TotalTime=" + this.getTotalTime() + ", LastSampleTime=" + this.getLastSampleTime();
    }
}

