/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import java.io.File;
import java.io.FileNotFoundException;
import junit.extensions.RepeatedTest;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.objectweb.howl.log.InvalidLogKeyException;
import org.objectweb.howl.log.LogClosedException;
import org.objectweb.howl.log.LogConfigurationException;
import org.objectweb.howl.log.LogException;
import org.objectweb.howl.log.LogRecord;
import org.objectweb.howl.log.LogRecordSizeException;
import org.objectweb.howl.log.LogTestWorker;
import org.objectweb.howl.log.Logger;
import org.objectweb.howl.log.TestDriver;
import org.objectweb.howl.log.TestLogReader;

public class LogTest
extends TestDriver {
    public LogTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.log = new Logger(this.cfg);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static void main(String[] args) throws Exception {
        TestRunner.run((Test)LogTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(LogTest.class);
        return new RepeatedTest((Test)suite, Integer.getInteger("LogTest.repeatcount", 1).intValue());
    }

    public void testGetHighMark() throws Exception {
        try {
            this.log.lfmgr.getHighMark();
            LogTest.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.log.open();
        this.log.lfmgr.getHighMark();
        this.log.close();
    }

    public void testGetHighMark_NewFiles() throws Exception {
        this.deleteLogFiles();
        try {
            this.log.lfmgr.getHighMark();
            LogTest.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.log.open();
        this.log.lfmgr.getHighMark();
        this.log.close();
    }

    public void testLoggerSingleThread() throws LogException, Exception {
        this.log.open();
        this.log.setAutoMark(true);
        this.prop.setProperty("msg.count", "10");
        this.workers = 1;
        this.runWorkers(LogTestWorker.class);
    }

    public void testLoggerAutomarkTrue() throws LogException, Exception {
        this.log.open();
        this.log.setAutoMark(true);
        this.runWorkers(LogTestWorker.class);
    }

    public void testLoggerReplay() throws Exception {
        this.log.open();
        TestLogReader reader = new TestLogReader();
        reader.run(this.log);
        System.err.println(this.getName() + "; total records processed: " + reader.recordCount);
    }

    public void testLoggerReplay_unforcedRecord() throws Exception {
        this.log.open();
        long key = this.log.put("".getBytes(), false);
        TestLogReader reader = new TestLogReader();
        this.log.replay(reader, key);
        if (reader.exception != null) {
            throw reader.exception;
        }
        this.log.close();
    }

    public void testLoggerReplay_forcedRecord() throws Exception {
        this.log.open();
        long key = this.log.put("".getBytes(), true);
        TestLogReader reader = new TestLogReader();
        this.log.replay(reader, key);
        if (reader.exception != null) {
            throw reader.exception;
        }
        this.log.close();
    }

    public void testMultipleClose() throws Exception {
        this.log.open();
        this.log.close();
        this.log.close();
    }

    public void testLoggerReplay_NewFiles() throws Exception {
        this.deleteLogFiles();
        this.log.open();
        TestLogReader reader = new TestLogReader();
        reader.run(this.log);
        System.err.println(this.getName() + "; total records processed: " + reader.recordCount);
    }

    public void testLogClosedException() throws Exception, LogException {
        this.log.open();
        this.log.close();
        try {
            this.log.setAutoMark(false);
            LogTest.fail((String)"expected LogClosedException");
        }
        catch (LogClosedException logClosedException) {
            // empty catch block
        }
    }

    public void testLogConfigurationException_Lock() throws Exception {
        this.log.open();
        Logger log2 = new Logger(this.cfg);
        try {
            log2.open();
        }
        catch (LogConfigurationException e) {
            log2.close();
        }
        this.log.close();
    }

    public void testLogConfigurationException_ClassNotFound() throws Exception {
        block2: {
            this.cfg.setBufferClassName("org.objectweb.howl.log.noSuchBufferClass");
            try {
                this.log.open();
                this.log.close();
                LogTest.fail((String)"expected LogConfigurationException");
            }
            catch (LogConfigurationException e) {
                if (e.getCause() instanceof ClassNotFoundException) break block2;
                throw e;
            }
        }
        this.log.close();
    }

    public void testLogConfigurationException_maxLogFiles() throws Exception {
        this.cfg.setMaxLogFiles(this.cfg.getMaxLogFiles() + 1);
        try {
            this.log.open();
            this.log.close();
            LogTest.fail((String)"expected LogConfigurationException");
        }
        catch (LogConfigurationException logConfigurationException) {
            // empty catch block
        }
        this.log.close();
    }

    public void testFileNotFoundException() throws Exception {
        File invalidDir = new File(this.outDir, "invalid");
        if (!invalidDir.exists() && !invalidDir.createNewFile()) {
            LogTest.fail((String)"unable to create 'invalid' directory");
        }
        String invalid = invalidDir.getPath();
        this.cfg.setLogFileDir(invalid);
        try {
            this.log.open();
            this.log.close();
            LogTest.fail((String)"expected FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void testLogConfigurationException_1File() throws Exception {
        this.cfg.setMaxLogFiles(1);
        try {
            this.log.open();
            this.log.close();
            LogTest.fail((String)"expected LogConfigurationException");
        }
        catch (LogConfigurationException logConfigurationException) {
            // empty catch block
        }
    }

    public void testLogRecordSizeException() throws Exception {
        this.log.open();
        byte[] data = new byte[this.cfg.getBufferSize() * 1024];
        try {
            this.log.put(data, false);
            LogTest.fail((String)"expected LogRecordSizeException");
        }
        catch (LogRecordSizeException logRecordSizeException) {
            // empty catch block
        }
        this.log.close();
    }

    public void testInvalidLogKeyException_NegativeKey() throws Exception {
        TestLogReader tlr = new TestLogReader();
        this.log.open();
        try {
            this.log.replay(tlr, -1L);
            this.log.close();
            LogTest.fail((String)"expected InvalidLogKeyException (-1)");
        }
        catch (InvalidLogKeyException invalidLogKeyException) {
            // empty catch block
        }
        this.log.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidLogKeyException_InvalidKey() throws Exception {
        TestLogReader tlr = new TestLogReader();
        this.log.open();
        try {
            this.log.replay(tlr, this.log.getActiveMark() + 1L);
            this.log.close();
            LogTest.fail((String)"expected InvalidLogKeyException");
        }
        catch (InvalidLogKeyException invalidLogKeyException) {
        }
        finally {
            this.saveStats();
        }
        this.log.close();
    }

    public void testBlockLogBufferSink() throws Exception {
        this.cfg.setBufferClassName("org.objectweb.howl.log.BlockLogBufferSink");
        this.log.open();
        this.log.setAutoMark(true);
        this.runWorkers(LogTestWorker.class);
    }

    public void testGetMethods() throws Exception {
        int i;
        int i2;
        DataRecords dr = new DataRecords(5);
        LogRecord lr = dr.lr;
        this.deleteLogFiles();
        this.log.open();
        dr.putAll(true);
        long pos = this.log.lfmgr.currentLogFile.channel.position();
        lr.setFilterCtrlRecords(true);
        for (i2 = 0; i2 < dr.sVal.length; ++i2) {
            dr.verify(i2);
        }
        for (i2 = dr.sVal.length - 1; i2 >= 0; --i2) {
            dr.verify(i2);
        }
        long posNow = this.log.lfmgr.currentLogFile.channel.position();
        LogTest.assertEquals((String)"File Position", (long)pos, (long)posNow);
        lr = dr.verify(0);
        for (int i3 = 1; i3 < dr.count; ++i3) {
            while ((lr = this.log.getNext(lr)).isCTRL()) {
            }
            dr.verify(i3, lr);
        }
        posNow = this.log.lfmgr.currentLogFile.channel.position();
        LogTest.assertEquals((String)"File Position", (long)pos, (long)posNow);
        int recordCount = 0;
        while (true) {
            lr = this.log.getNext(lr);
            if (lr.type == 19983) break;
            ++recordCount;
        }
        posNow = this.log.lfmgr.currentLogFile.channel.position();
        LogTest.assertEquals((String)"File Position", (long)pos, (long)posNow);
        int j = 0;
        int i4 = dr.count - 1;
        while (i4 >= 0) {
            lr = dr.verify(i4);
            this.log.put(dr.r1[j], true);
            --i4;
            ++j;
        }
        lr = dr.verify(0);
        for (i = 1; i < dr.count; ++i) {
            while ((lr = this.log.getNext(lr)).isCTRL()) {
            }
            dr.verify(i, lr);
        }
        for (i = 0; i < dr.count; ++i) {
            while ((lr = this.log.getNext(lr)).isCTRL()) {
            }
            this.verifyLogRecord(lr, dr.sVal[i], lr.key);
        }
        this.log.close();
    }

    public void testGetMethods_UnforcedRecord() throws Exception {
        DataRecords dr = new DataRecords(1);
        this.log.open();
        dr.putAll(false);
        dr.verify(0);
        this.log.close();
    }

    void verifyLogRecord(LogRecord lr, String eVal, long eKey) {
        byte[][] r2 = lr.getFields();
        String rVal = new String(r2[0]);
        LogTest.assertEquals((String)("Record Type: " + Long.toHexString(lr.type)), (int)0, (int)lr.type);
        LogTest.assertEquals((String)("Record Key: " + Long.toHexString(eKey)), (long)eKey, (long)lr.key);
        LogTest.assertEquals((String)"Record Data", (String)eVal, (String)rVal);
        LogTest.assertEquals((String)"Field Count != 1", (int)1, (int)r2.length);
    }

    class DataRecords {
        final int count;
        final String[] sVal;
        final byte[][] r1;
        final long[] key;
        final LogRecord lr;

        DataRecords(int count) {
            this.count = count;
            this.sVal = new String[count];
            this.r1 = new byte[count][];
            this.key = new long[count];
            for (int i = 0; i < count; ++i) {
                this.sVal[i] = "Record_" + (i + 1);
                this.r1[i] = this.sVal[i].getBytes();
            }
            int last = count - 1;
            this.lr = new LogRecord(this.sVal[last].length() + 6);
        }

        void putAll(boolean forceLastRecord) throws Exception {
            for (int i = 0; i < this.count; ++i) {
                boolean force = i == this.sVal.length - 1 ? forceLastRecord : false;
                this.key[i] = LogTest.this.log.put(this.r1[i], force);
            }
        }

        LogRecord verify(int index) throws Exception {
            LogTest.this.log.get(this.lr, this.key[index]);
            LogTest.this.verifyLogRecord(this.lr, this.sVal[index], this.key[index]);
            return this.lr;
        }

        LogRecord verify(int index, LogRecord lr) throws Exception {
            LogTest.this.verifyLogRecord(lr, this.sVal[index], this.key[index]);
            return lr;
        }
    }
}

