/**
 *	JFractionLab
 *	Copyright (C) 2005 jochen georges, gnugeo _ at _ gnugeo _ dot _ de
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

package jfractionlab.jflOptionDialogs;

import info.clearthought.layout.TableLayout;

import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

import jfractionlab.JFractionLab;

public class InfoDialog extends JDialog implements ActionListener, KeyListener{
	static final long serialVersionUID = JFractionLab.serialVersionUID;
		private JEditorPane jep_info = new JEditorPane();
		private JButton btn_OK = new JButton("");

	/**
	* Macht einen neuen Dialog
	*
	* @param owner aufrufende Klasse vom Typ JoQu
	* @param title der Titel des Dialoges
	* @param modal wenn true ist das neue Dialogfenster modal
	*/
	public InfoDialog(){ //neues Spiel machen
		setTitle(lang.Messages.getString("about_jfl"));
		
		setLocation(150, 150);
		setSize(500,400);
		setResizable(false);
		setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		makeGUI();
	}//Konstruktor

	/**
	 * 
	 *
	 */
	private void makeGUI(){
		double sizes[][] = {{
			10, TableLayout.FILL, 10
		},{
			10, TableLayout.FILL, 50,10
		}}; //Spalten / Zeilen
		Container content = getContentPane();
	        content.setLayout(new TableLayout(sizes));
		content.setBackground(Color.white);
		
		jep_info.setContentType("text/html");
			String howtotxt = JFractionLab.jep_fontface + "<b>"
				+ lang.Messages.getString("gnu_gpl")+"<br>"
				+ lang.Messages.getString("copyright")+"<br>"
				+ lang.Messages.getString("url_text")+"<br>"
				+ lang.Messages.getString("emailaddress")+"<br>"
				+"<br>"
				+ lang.Messages.getString("thanks_to")+"<br><ul><li>"
				
				//x.oswald@free.fr
				//y.durand@gmx.de
				+ lang.Messages.getString("french_translators")+"</li><li>"
				
				//pablo.pita@pitagoral.com
				+ lang.Messages.getString("spanish_translators")+"</li><li>"
				
				//gudrungeorges@gmail.com
				+ lang.Messages.getString("english_translators")+"</li><li>"
				
				//Loupiotebec@aol.com
				+ lang.Messages.getString("italian_translators")+"</li><li>"
				
				//khemis@bol.com.br
				+ lang.Messages.getString("portuguese_translators")+"</li><li>"
				
				//cazaria@gmx.net
//				+ lang.Messages.getString("polish_translators")+"</li><li>"
				
				//jredrejo@edu.juntaextremadura.net>
				+ lang.Messages.getString("debian_package_maintainer")+"</li><li>"
				
				+ lang.Messages.getString("icon_designer")+"</li></ul></b></font>"
			;//String
			jep_info.setText(howtotxt);
			jep_info.setEditable(false);
			jep_info.setFocusable(false);
		content.add(new JScrollPane(jep_info), "1,1");
		
		btn_OK.addActionListener(this);
		btn_OK.addKeyListener(this);
		btn_OK.setText(lang.Messages.getString("OK"));
		content.add(btn_OK, "1,2,c,c");
		setVisible(true);
	}//makeGUI

	public void actionPerformed(ActionEvent e){
		Object obj = e.getSource();
		if (obj == btn_OK){
			setVisible(false);
			dispose();
		}
	}//actionPerformed

	@Override
	public void keyPressed(KeyEvent e) {
		int key = e.getKeyCode();
		Object obj = e.getSource();
		if(key == KeyEvent.VK_ENTER && obj == btn_OK){
			setVisible(false);
			dispose();
		}
	}
	@Override
	public void keyReleased(KeyEvent e) {}
	@Override
	public void keyTyped(KeyEvent e) {}

	}//class InfoDialog
