package jfractionlab.jflDialogs;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.JFrame;

import jfractionlab.ConfManager;
import jfractionlab.JFractionLab;

public class ConfigurePDFLATEXDialog extends WorkSheetDialog{
	static final long serialVersionUID = JFractionLab.serialVersionUID;

	public ConfigurePDFLATEXDialog(){
		super(false);
		lbTitle.setText(lang.Messages.getString("configure_pdflatex"));
		lbFileText.setText(
				"<html><body>"+
				lang.Messages.getString("miktex_has_to_be_installed")+"<br>"+
				lang.Messages.getString("insert_path_to_pdflatex")+
				"</body></html>"
		);
		jtfFile.setText(new ConfManager().getWinPathToPDFLATEX());
		setLocation(150, 150);
		setSize(500,300);
		setResizable(true);
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		pack();
		setVisible(true);
	}
	
	private void okAction(){
		new ConfManager().setWinPathToPDFLATEX(jtfFile.getText());
		System.out.println(
				"pdflatex dialog conf = "+
				new ConfManager().isTipAtStart()+
				", "+
				new ConfManager().getWinPathToPDFLATEX()
		);
		close();
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		Object obj = e.getSource();
		if (obj == btnCancel){
				close();
		}else if(obj == btnOK){
			okAction();
		}else if (obj == btnChooseFile){
			jtfFile.setText(chooseFileName());
		}
	}
	@Override
	public void keyPressed(KeyEvent event){
		int key = event.getKeyCode();
		Object obj = event.getSource();
		if(key == KeyEvent.VK_ENTER && obj == btnCancel){
			close();
		}else if(key == KeyEvent.VK_ENTER && obj == btnOK){
			okAction();
		}
	}
}