// $Header: /home/cvs/jakarta-jmeter/src/core/org/apache/jmeter/engine/RemoteJMeterEngine.java,v 1.5 2004/02/12 23:59:01 sebb Exp $
/*
 * Copyright 2001-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
*/

package org.apache.jmeter.engine;

import java.rmi.Remote;
import java.rmi.RemoteException;

import org.apache.jorphan.collections.HashTree;

/**
 * @version $Revision: 1.5 $ Last updated $Date: 2004/02/12 23:59:01 $
 */
public interface RemoteJMeterEngine extends Remote
{
    void configure(HashTree testTree) throws RemoteException;
    void runTest() throws RemoteException,JMeterEngineException;
    void stopTest() throws RemoteException;
    void reset() throws RemoteException;
    void setHost(String host) throws RemoteException;
	void exit() throws RemoteException;
}
