// $Header: /home/cvs/jakarta-jmeter/src/core/org/apache/jmeter/functions/Function.java,v 1.5 2004/02/14 03:34:29 sebb Exp $
/*
 * Copyright 2001-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
*/

package org.apache.jmeter.functions;

import java.util.Collection;
import java.util.List;

import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;

/**
 * @author mstover
 * @version $Revision: 1.5 $
 */
public interface Function
{
    /**
     * Given the previous SampleResult and the current Sampler, return
     * a string to use as a replacement value for the function call.
     * Assume "setParameter" was previously called.
     * 
     * This method must be threadsafe - multiple threads will be using
     * the same object.
     */
    public String execute(SampleResult previousResult, Sampler currentSampler)
        throws InvalidVariableException;

    /**
     * A collection of the parameters used to configure your function. Each
     * parameter is a CompoundFunction and can be resolved by calling the
     * execute() method of the CompoundFunction (which should be done at
     * execution.)
     * 
     * @param parameters
     * @throws InvalidVariableException
     */
    public void setParameters(Collection parameters)
        throws InvalidVariableException;

    /**
     * Return the name of your function.  Convention is to prepend "__"
     * to the name (ie "__regexFunction")
     */
    public String getReferenceKey();

    /**
     * Return a list of strings briefly describing each parameter
     * your function takes.  Please use JMeterUtils.getResString(resource_name)
     * to grab a resource string.  Otherwise, your help text will be
     * difficult to internationalize.  Add your strings to all
     * org.apache.jmeter.resources.*.properties files.  Do not worry
     * about translating - that's someone else's responsibility.
     * 
     * This list is not optional.  If you don't wish to write help, you
     * must at least return a List containing the correct number of
     * blank strings, one for each argument.
     */
    public List getArgumentDesc();
}
