// $Header: /home/cvs/jakarta-jmeter/src/core/org/apache/jmeter/gui/action/AddParent.java,v 1.8 2004/02/13 02:21:36 sebb Exp $
/*
 * Copyright 2002-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
*/

package org.apache.jmeter.gui.action;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;

import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/**
 * @author    Michael Stover
 * @version   $Revision: 1.8 $
 */
public class AddParent implements Command
{
    transient private static Logger log = LoggingManager.getLoggerForClass();
    private static Set commands = new HashSet();
    static
    {
        commands.add("Add Parent");
    }

    public AddParent()
    {
    }

    public void doAction(ActionEvent e)
    {
        String name = ((Component) e.getSource()).getName();
        try
        {
            TestElement controller =
                (TestElement) GuiPackage.getInstance().createTestElement(name);
            addParentToTree(controller);
        }
        catch (Exception err)
        {
            log.error("", err);
        }

    }

    public Set getActionNames()
    {
        return commands;
    }

    protected void addParentToTree(TestElement newParent)
    {
        GuiPackage guiPackage = GuiPackage.getInstance();
        JMeterTreeNode newNode =
            new JMeterTreeNode(newParent, guiPackage.getTreeModel());
        JMeterTreeNode currentNode =
            guiPackage.getTreeListener().getCurrentNode();
        JMeterTreeNode parentNode = (JMeterTreeNode) currentNode.getParent();
        int index = parentNode.getIndex(currentNode);
        guiPackage.getTreeModel().removeNodeFromParent(currentNode);
        guiPackage.getTreeModel().insertNodeInto(
            newNode,
            (JMeterTreeNode) parentNode,
            index);
        guiPackage.getTreeModel().insertNodeInto(
            currentNode,
            newNode,
            newNode.getChildCount());
    }
}
