// $Header: /home/cvs/jakarta-jmeter/src/core/org/apache/jmeter/gui/action/Clear.java,v 1.8 2004/02/20 01:03:07 jsalvata Exp $
/*
 * Copyright 2001-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
*/

package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/**
 * @author     Michael Stover
 * @version    $Revision: 1.8 $
 */
public class Clear implements Command
{
    transient private static Logger log = LoggingManager.getLoggerForClass();
    public final static String CLEAR = "action.clear";
    public final static String CLEAR_ALL = "action.clear_all";

    private static Set commands = new HashSet();
    static
    {
        commands.add(CLEAR);
        commands.add(CLEAR_ALL);
    }

    public Clear()
    {
    }

    public Set getActionNames()
    {
        return commands;
    }

    public void doAction(ActionEvent e)
    {
        GuiPackage guiPackage = GuiPackage.getInstance();
        if (e.getActionCommand().equals(CLEAR))
        {
            JMeterGUIComponent model = guiPackage.getCurrentGui();
            try
            {
                ((Clearable) model).clear();
            }
            catch (Throwable ex)
            {
                log.error("", ex);
            }
        }
        else
        {
            Iterator iter =
                guiPackage
                    .getTreeModel()
                    .getNodesOfType(Clearable.class)
                    .iterator();
            while (iter.hasNext())
            {
                try
                {
                    Clearable item =
                        (Clearable) guiPackage.getGui(
                            ((JMeterTreeNode) iter.next()).getTestElement());
                    item.clear();
                }
                catch (Exception ex)
                {
                    log.error("", ex);
                }
            }
        }
    }
}
