#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <jvmpi.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <obj.h>

obj* obj_new (jint arena_id, cls* class_id, jint is_array,
	      jint size, jobjectID obj_id, method* method,
	      int level) {
    obj* o = malloc (sizeof (*o));
    if (o == NULL)
	return NULL;
    o->arena_id = arena_id;
    o->clz = class_id;
    o->is_array = is_array;
    o->size = size;
    o->obj_id = obj_id;
    o->method = method;
    o->level = level;
    return o;
}

void obj_free (obj* c) {
    free (c);
}

size_t obj_jmphash_func (void* c, size_t len) {
    obj* o = (obj*)c;
    return ((long)o->obj_id) % len;
}

int obj_cmp_func (void* c1, void* c2) {
    obj* o1;
    obj* o2;
    o1 = (obj*)c1;
    o2 = (obj*)c2;
    if (o1 == NULL || o2 == NULL)
	return 1;    
    return o1->obj_id != o2->obj_id; 
} 

void obj_print (obj* o) {
    fprintf (stdout, "OBJECT (%p): arena: %d, class_id: %p, is_array: %d, size: %d, obj_id: %p\n", 
	     o, o->arena_id, cls_get_class_id (o->clz), o->is_array, o->size, o->obj_id);
}

inline jobjectID obj_get_object_id (obj* o) {
    return o->obj_id;
}

inline void obj_set_object_id (obj* o, jobjectID obj_id) {
    o->obj_id = obj_id;
}

inline cls* obj_get_class (obj* o) {
    return o->clz;
}

inline jobjectID obj_get_class_id (obj* o) {
    return cls_get_class_id (o->clz);
}

inline jint obj_get_size (obj* o) {
    return o->size;
}

inline void obj_set_arena_id (obj* o, jint arena_id) {
    o->arena_id = arena_id;
}

inline int obj_get_level (obj* o) {
    return o->level;
}


/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
