#ifndef COMPARATORS_H__
#define COMPARATORS_H__

/** Compare two jthreads by there name. */
int jthread_compr_name (const void* v1, const void* v2);

/** compare threads based on thread group */
int jthread_compr_group (const void* v1, const void* v2);

/** compare threads based on thread parent */
int jthread_compr_parent (const void* v1, const void* v2);

/** Compare threads based on contenation time for the threads. */
int jthread_compr_contenation (const void* v1, const void* v2);

/** Compare threads based on thread state. */
int jthread_compr_state (const void* v1, const void* v2);

/** Compare threads based on consumed cpu time. */
int jthread_compr_cputime (const void* v1, const void* v2);


/** compare classes based on class name */
int cls_compr_name (const void* v1, const void* v2);

/** compare classes based on instance count */
int cls_compr_instance (const void* v1, const void* v2);

/** compare classes based on maximum instance count */
int cls_compr_max_instance (const void* v1, const void* v2);

/** compare classes based on current size in bytes */
int cls_compr_size (const void* v1, const void* v2);

/** compare classes based on number of garbage collected instances */
int cls_compr_instance_gc (const void* v1, const void* v2);

/** compare classes based on garbage collection survivability  */
int cls_compr_tenure (const void* v1, const void* v2);


/** Compare methods based on signature. */
int method_compr_signature (const void* v1, const void* v2);

/** Compare methods based on method name (and signature if needed) */
int method_compr_name (const void* v1, const void* v2);

/** Compare method based on class name, method name and signature (in that order) */
int method_compr_class (const void* v1, const void* v2);

/** Compare methods based on used time in the method. */
int method_compr_time (const void* v1, const void* v2);

/** Compare methods based on number of calls. */
int method_compr_calls (const void* v1, const void* v2);

/** Compare methods based on time used in method called from this method. */
int method_compr_hold_time (const void* v1, const void* v2);

/** Compare methods based on total time per call. */
int method_compr_total_time_per_call (const void* v1, const void* v2);

/** Compare methods based on time used in this method and method called from this method. */
int method_compr_total_time (const void* v1, const void* v2);

/** Compare methods based on allocated objects */
int method_compr_objects (const void* v1, const void* v2);

/** Compare methods based on allocated objects */
int method_compr_objpercall (const void* v1, const void* v2);

/** Compare methods based on allocated memory */
int method_compr_bytes (const void* v1, const void* v2);
#endif /* COMPARATORS_H__ */ 

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
