/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.or.ObjectRenderer;

public class BasicConfigurator {
    public static final String DISABLE_OVERRIDE_KEY = "log4j.disableOverride";
    public static final String DISABLE_KEY = "log4j.disable";
    public static final String INHERITED = "inherited";
    static /* synthetic */ Class class$org$apache$log4j$or$ObjectRenderer;

    protected BasicConfigurator() {
    }

    protected void addRenderer(Hierarchy hierarchy, String renderedClassName, String renderingClassName) {
        LogLog.debug("Rendering class: [" + renderingClassName + "], Rendered class: [" + renderedClassName + "].");
        ObjectRenderer renderer = (ObjectRenderer)OptionConverter.instantiateByClassName(renderingClassName, class$org$apache$log4j$or$ObjectRenderer == null ? (class$org$apache$log4j$or$ObjectRenderer = BasicConfigurator.class$("org.apache.log4j.or.ObjectRenderer")) : class$org$apache$log4j$or$ObjectRenderer, null);
        if (renderer == null) {
            LogLog.error("Could not instantiate renderer [" + renderingClassName + "].");
            return;
        }
        try {
            Class<?> renderedClass = Class.forName(renderedClassName);
            hierarchy.rendererMap.put(renderedClass, renderer);
        }
        catch (ClassNotFoundException e) {
            LogLog.error("Could not find class [" + renderedClassName + "].", e);
        }
    }

    public static void disable(String priorityStr) {
        Category.getDefaultHierarchy().disable(priorityStr);
    }

    public static void disable(Priority p) {
    }

    public static void disableAll() {
        Category.getDefaultHierarchy().disable(Priority.FATAL);
    }

    public static void disableDebug() {
        Category.getDefaultHierarchy().disable(Priority.DEBUG);
    }

    public static void disableInfo() {
        Category.getDefaultHierarchy().disable(Priority.INFO);
    }

    public static void enableAll() {
        Category.getDefaultHierarchy().disable(Priority.INFO);
    }

    public static void configure() {
        Category root = Category.getRoot();
        root.addAppender(new ConsoleAppender(new PatternLayout("%r [%t] %p %c %x - %m%n")));
    }

    public static void configure(Appender appender) {
        Category root = Category.getRoot();
        root.addAppender(appender);
    }

    public static void resetConfiguration() {
        Category.defaultHierarchy.resetConfiguration();
    }

    public static void resetConfiguration(Hierarchy hierarchy) {
        hierarchy.resetConfiguration();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String override = OptionConverter.getSystemProperty(DISABLE_OVERRIDE_KEY, null);
        if (override != null) {
            Category.defaultHierarchy.setDisableOverride(override);
        } else {
            String disableStr = OptionConverter.getSystemProperty(DISABLE_KEY, null);
            if (disableStr != null) {
                Category.defaultHierarchy.disable(disableStr);
            }
        }
    }
}

