/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.oscache.base;

import com.opensymphony.module.oscache.base.CacheLog;
import com.opensymphony.module.oscache.base.CacheProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Properties;
import javax.swing.event.EventListenerList;

public abstract class AbstractCacheAdministrator
implements Serializable {
    private static final String FILE_SEPARATOR_KEY = "file.separator";
    private static final String CACHE_DEBUG_KEY = "cache.debug";
    private static final String CACHE_PATH_KEY = "cache.path";
    private static final String CACHE_MEMORY_KEY = "cache.memory";
    private static final String CACHE_ALGORITHM_KEY = "cache.algorithm";
    private static final String CACHE_CAPACITY_KEY = "cache.capacity";
    private static final String CACHE_DISK_UNLIMITED_KEY = "cache.unlimited_disk";
    private static final String PROPERTIES_FILENAME = "/oscache.properties";
    public static final String DEFAULT_CACHE_KEY = "__oscache_cache";
    protected static final String FILE_SEPARATOR = System.getProperty("file.separator");
    protected static final char FILE_SEPARATOR_CHAR = System.getProperty("file.separator").charAt(0);
    protected EventListenerList listenerList = new EventListenerList();
    private CacheLog cacheLogImpl = null;
    private CacheProperties cachePropertiesImpl = null;
    private Properties properties;
    private boolean memoryCaching = true;
    private boolean unlimitedDiskCache = false;
    private File cachePath = null;
    private boolean debug = false;
    protected String algorithmClass = null;
    protected int cacheCapacity = -1;

    public File getCachePath() {
        return this.cachePath;
    }

    /*
     * Loose catch block
     */
    private void loadProps() {
        block8: {
            CacheProperties cacheProperties;
            block9: {
                cacheProperties = this.getCacheProperties();
                if (cacheProperties != null) break block9;
                this.properties = new Properties();
                InputStream inputStream = null;
                inputStream = this.getClass().getResourceAsStream(PROPERTIES_FILENAME);
                this.properties.load(inputStream);
                Object var4_3 = null;
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                break block8;
                {
                    catch (IOException iOException) {
                        this.logError("Error reading cachetags.properties in CacheAdministrator.loadProps() " + iOException);
                        this.logError("Ensure the cachetags.properties file is readable and in your classpath.");
                        Object var4_4 = null;
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            cacheProperties.loadProperties();
        }
    }

    public String getProperty(String string) {
        CacheProperties cacheProperties = this.getCacheProperties();
        String string2 = cacheProperties != null ? cacheProperties.getProperty(string) : this.properties.getProperty(string);
        return string2;
    }

    private void initDebug() {
        String string = this.getProperty(CACHE_DEBUG_KEY);
        if (string != null && string.equalsIgnoreCase("true")) {
            this.debug = true;
        }
    }

    private boolean isDebug() {
        return this.debug;
    }

    private boolean initFileCaching() {
        block1: {
            block2: {
                String string = this.getProperty(CACHE_PATH_KEY);
                if (string == null) break block1;
                this.cachePath = new File(string);
                if (!this.cachePath.exists()) {
                    this.log("cache.path does not exist, creating");
                    this.cachePath.mkdirs();
                }
                if (this.cachePath.isDirectory()) break block2;
                this.logError("cache.path is not a directory");
                this.cachePath = null;
                break block1;
            }
            if (this.cachePath.canWrite()) break block1;
            this.logError("cache.path is not a writable location");
            this.cachePath = null;
        }
        return this.isFileCaching();
    }

    public boolean isFileCaching() {
        return this.cachePath != null;
    }

    private boolean initMemoryCaching() {
        block0: {
            String string = this.getProperty(CACHE_MEMORY_KEY);
            if (string == null || !string.equalsIgnoreCase("false")) break block0;
            this.memoryCaching = false;
        }
        return this.memoryCaching;
    }

    private void initCacheParameters() {
        this.algorithmClass = this.getProperty(CACHE_ALGORITHM_KEY);
        String string = this.getProperty(CACHE_CAPACITY_KEY);
        if (string != null && string.length() > 0) {
            this.cacheCapacity = Integer.parseInt(this.getProperty(CACHE_CAPACITY_KEY));
        }
        this.unlimitedDiskCache = Boolean.valueOf(this.getProperty(CACHE_DISK_UNLIMITED_KEY));
    }

    public boolean isMemoryCaching() {
        return this.memoryCaching;
    }

    public boolean isUnlimitedDiskCache() {
        return this.unlimitedDiskCache;
    }

    public void log(String string) {
        this.log(string, System.out);
    }

    protected void logError(String string) {
        this.log(string, System.err);
    }

    public void log(String string, PrintStream printStream) {
        if (printStream == null) {
            printStream = System.out;
        }
        if (this.isDebug() || printStream.equals(System.err)) {
            CacheLog cacheLog = this.getCacheLog();
            if (cacheLog != null) {
                cacheLog.log(string, printStream);
            } else {
                printStream.println("[oscache]: " + string);
            }
        }
    }

    public void setCacheLog(CacheLog cacheLog) {
        this.cacheLogImpl = cacheLog;
    }

    private CacheLog getCacheLog() {
        return this.cacheLogImpl;
    }

    public void setCacheProperties(CacheProperties cacheProperties) {
        this.cachePropertiesImpl = cacheProperties;
    }

    private CacheProperties getCacheProperties() {
        return this.cachePropertiesImpl;
    }

    public void setAlgorithmClass(String string) {
        this.algorithmClass = string;
    }

    public void setCacheCapacity(int n) {
        this.cacheCapacity = n;
    }

    protected AbstractCacheAdministrator() {
        this.loadProps();
        this.initDebug();
        this.initFileCaching();
        this.initMemoryCaching();
        this.initCacheParameters();
        this.log("Constructed AbstractCacheAdministrator()");
    }
}

