/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.oscache.web;

import com.opensymphony.module.oscache.base.Cache;
import com.opensymphony.module.oscache.base.CacheEntry;
import com.opensymphony.module.oscache.base.NeedsRefreshException;
import com.opensymphony.module.oscache.web.ServletCacheAdministrator;
import java.io.Serializable;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public final class ServletCache
extends Cache
implements HttpSessionBindingListener,
Serializable {
    private int scope;
    private ServletCacheAdministrator admin;

    public int getScope() {
        return this.scope;
    }

    public Object getFromCache(String string, int n) throws NeedsRefreshException {
        CacheEntry cacheEntry = ServletCache.super.getCacheEntry(string, null);
        Object object = cacheEntry.getContent();
        if (cacheEntry.needsRefresh(n) || this.isFlushed(cacheEntry) || this.admin.isScopeFlushed(cacheEntry, this.scope)) {
            throw new NeedsRefreshException(object);
        }
        return object;
    }

    public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
    }

    public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
        this.admin.log("[Cache] Unbound from session " + httpSessionBindingEvent.getSession().getId() + " using name " + httpSessionBindingEvent.getName());
        this.clear();
    }

    public ServletCache(ServletCacheAdministrator servletCacheAdministrator, int n) {
        super(servletCacheAdministrator.isMemoryCaching(), servletCacheAdministrator.isUnlimitedDiskCache());
        this.scope = n;
        this.admin = servletCacheAdministrator;
    }

    public ServletCache(ServletCacheAdministrator servletCacheAdministrator, String string, int n, int n2) {
        super(servletCacheAdministrator.isMemoryCaching(), servletCacheAdministrator.isUnlimitedDiskCache(), string, n);
        this.admin = servletCacheAdministrator;
        this.scope = n2;
    }
}

