/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import org.gjt.jclasslib.io.Log;
import org.gjt.jclasslib.structures.AccessFlags;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;

public abstract class AbstractStructure {
    public static final String SYSTEM_PROPERTY_DEBUG = "jclasslib.io.debug";
    protected ClassFile classFile;
    protected boolean debug = Boolean.getBoolean("jclasslib.io.debug");

    protected AbstractStructure() {
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public void setClassFile(ClassFile classFile) {
        this.classFile = classFile;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    protected int getLength(Object object) {
        if (object == null || !object.getClass().isArray()) {
            return 0;
        }
        return Array.getLength(object);
    }

    protected void debug(String string) {
        if (this.debug) {
            Log.debug(string);
        }
    }

    protected String printBytes(int n) {
        return this.padHexString(Integer.toHexString(n), 8);
    }

    protected String printAccessFlags(int n) {
        return this.padHexString(Integer.toHexString(n), 4);
    }

    private String padHexString(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer("0x");
        int n2 = string.length();
        while (n2 < n) {
            stringBuffer.append('0');
            ++n2;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected String printAccessFlagsVerbose(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this instanceof ClassFile;
        int n2 = 0;
        while (n2 < AccessFlags.allAccessFlags.length) {
            if (!(bl && AccessFlags.allAccessFlags[n2] == 32 || (n & AccessFlags.allAccessFlags[n2]) == 0)) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(AccessFlags.allAccessFlagsVerbose[n2]);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

