/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.attributes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.attributes.ExceptionTableEntry;

public class CodeAttribute
extends AttributeInfo {
    public static final String ATTRIBUTE_NAME = "Code";
    private static final int INITIAL_LENGTH = 12;
    private int maxStack;
    private int maxLocals;
    private byte[] code;
    private ExceptionTableEntry[] exceptionTable;

    public int getMaxStack() {
        return this.maxStack;
    }

    public void setMaxStack(int n) {
        this.maxStack = n;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public void setMaxLocals(int n) {
        this.maxLocals = n;
    }

    public byte[] getCode() {
        return this.code;
    }

    public void setCode(byte[] byArray) {
        this.code = byArray;
    }

    public ExceptionTableEntry[] getExceptionTable() {
        return this.exceptionTable;
    }

    public void setExceptionTable(ExceptionTableEntry[] exceptionTableEntryArray) {
        this.exceptionTable = exceptionTableEntryArray;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        this.maxStack = dataInput.readUnsignedShort();
        this.maxLocals = dataInput.readUnsignedShort();
        int n = dataInput.readInt();
        this.code = new byte[n];
        dataInput.readFully(this.code);
        this.readExceptionTable(dataInput);
        this.readAttributes(dataInput);
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        dataOutput.writeShort(this.maxStack);
        dataOutput.writeShort(this.maxLocals);
        dataOutput.writeInt(this.getLength(this.code));
        dataOutput.write(this.code);
        this.writeExceptionTable(dataOutput);
        this.writeAttributes(dataOutput);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    private void readExceptionTable(DataInput dataInput) throws InvalidByteCodeException, IOException {
        int n = dataInput.readUnsignedShort();
        this.exceptionTable = new ExceptionTableEntry[n];
        int n2 = 0;
        while (n2 < n) {
            this.exceptionTable[n2] = ExceptionTableEntry.create(dataInput, this.classFile);
            ++n2;
        }
    }

    private void writeExceptionTable(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        int n = this.getLength(this.exceptionTable);
        dataOutput.writeShort(n);
        int n2 = 0;
        while (n2 < n) {
            this.exceptionTable[n2].write(dataOutput);
            ++n2;
        }
    }

    public int getAttributeLength() {
        return 12 + this.getLength(this.code) + this.getLength(this.exceptionTable) * 8 + 6 * this.getLength(this.attributes) + this.getTotalAttributesLength();
    }

    protected void debug(String string) {
        super.debug(string + "Code attribute with max_stack " + this.maxStack + ", max_locals " + this.maxLocals + ", code_length " + this.getLength(this.code));
    }
}

