/*********************************************************************
 *
 *      Copyright (C) 2002 Nathan Fiedler
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * PROJECT:     JSwat
 * MODULE:      Expression
 * FILE:        Errors.java
 *
 * AUTHOR:      Nathan Fiedler
 *
 * REVISION HISTORY:
 *      Name    Date            Description
 *      ----    ----            -----------
 *      nf      06/02/02        Initial version
 *
 * $Id: Errors.java 1086 2003-12-04 08:41:02Z nfiedler $
 *
 ********************************************************************/

package com.bluemarsh.jswat.expr;

/**
 * Set of possible parser errors.
 *
 * @author  Nathan Fiedler
 */
class Errors {
    /** No error has occurred. */
    public static final int NO_ERROR = 0;
    /** Parser encountered a token it did not expect. */
    public static final int UNEXPECTED_TOKEN = 1;
    /** Parser encountered a token it does not support. */
    public static final int UNSUPPORTED_TOKEN = 2;
    /** Parser is in an unknown state. */
    public static final int UNKNOWN_STATE = 3;
    /** Parser found an unmatched right parenthesis. */
    public static final int UNMATCHED_RPAREN = 4;
    /** Parser encountered an unmatched left parenthesis. */
    public static final int UNMATCHED_LPAREN = 5;
    /** Parser found an operator but insufficient arguments. */
    public static final int MISSING_ARGS = 6;
    /** Expression was invalid. */
    public static final int INVALID_EXPR = 7;
    /** Parser found an unmatched right bracket. */
    public static final int UNMATCHED_RBRACKET = 8;
    /** Parser encountered an unmatched left bracket. */
    public static final int UNMATCHED_LBRACKET = 9;
    /** Array reference has multiple index values. */
    public static final int ARRAY_MULTI_INDEX = 10;
    /** Dot must be followed by an identifier. */
    public static final int DOT_REQUIRES_ID = 11;
    /** Feature is not supported. */
    public static final int UNSUPPORTED_FEATURE = 12;
    /** Parser found an invalid number. */
    public static final int NUMBER_FORMAT = 13;

    /**
     * This class is not to be instantiated.
     */
    private Errors() {
    } // Errors

    /**
     * Retrieve the localized message for the given error value.
     *
     * @param  error  error value.
     * @return  localized error message.
     */
    public static String getMessage(int error) {
        if (error == UNEXPECTED_TOKEN) {
            return Bundle.getString("error.unexpectedToken");
        } else if (error == UNSUPPORTED_TOKEN) {
            return Bundle.getString("error.unsupportedToken");
        } else if (error == UNKNOWN_STATE) {
            return Bundle.getString("error.unknownState");
        } else if (error == UNMATCHED_RPAREN) {
            return Bundle.getString("error.unmatchedRParen");
        } else if (error == UNMATCHED_LPAREN) {
            return Bundle.getString("error.unmatchedLParen");
        } else if (error == UNMATCHED_RBRACKET) {
            return Bundle.getString("error.unmatchedRBracket");
        } else if (error == UNMATCHED_LBRACKET) {
            return Bundle.getString("error.unmatchedLBracket");
        } else if (error == MISSING_ARGS) {
            return Bundle.getString("error.missingArgs");
        } else if (error == INVALID_EXPR) {
            return Bundle.getString("error.invalidExpr");
        } else if (error == ARRAY_MULTI_INDEX) {
            return Bundle.getString("error.arrayMultiIndex");
        } else if (error == DOT_REQUIRES_ID) {
            return Bundle.getString("error.dotNeedsIdent");
        } else if (error == UNSUPPORTED_FEATURE) {
            return Bundle.getString("error.unsupportedFeature");
        } else if (error == NUMBER_FORMAT) {
            return Bundle.getString("error.numberFormat");
        } else {
            return "";
        }
    } // getMessage
} // Errors
