/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.bytecode;

import java.io.IOException;
import org.gjt.jclasslib.bytecode.ImmediateByteInstruction;
import org.gjt.jclasslib.io.ByteCodeInput;
import org.gjt.jclasslib.io.ByteCodeOutput;

public class IncrementInstruction
extends ImmediateByteInstruction {
    private int incrementConst;

    public IncrementInstruction(int n, boolean bl) {
        super(n, bl);
    }

    public IncrementInstruction(int n, boolean bl, int n2, int n3) {
        super(n, bl, n2);
        this.incrementConst = n3;
    }

    public int getSize() {
        return super.getSize() + (this.wide ? 2 : 1);
    }

    public int getIncrementConst() {
        return this.incrementConst;
    }

    public void setIncrementConst(int n) {
        this.incrementConst = n;
    }

    public void read(ByteCodeInput byteCodeInput) throws IOException {
        super.read(byteCodeInput);
        this.incrementConst = this.wide ? byteCodeInput.readUnsignedShort() : byteCodeInput.readUnsignedByte();
    }

    public void write(ByteCodeOutput byteCodeOutput) throws IOException {
        super.write(byteCodeOutput);
        if (this.wide) {
            byteCodeOutput.writeShort(this.incrementConst);
        } else {
            byteCodeOutput.writeByte(this.incrementConst);
        }
    }
}

