/*********************************************************************
 *
 *      Copyright (C) 2003 Nathan Fiedler
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * PROJECT:     JSwat
 * MODULE:      View
 * FILE:        TooltipProducer.java
 *
 * AUTHOR:      Nathan Fiedler
 *
 * REVISION HISTORY:
 *      Name    Date            Description
 *      ----    ----            -----------
 *      nf      11/05/03        Initial version
 *
 * $Id: TooltipProducer.java 1050 2003-11-17 02:29:07Z nfiedler $
 *
 ********************************************************************/

package com.bluemarsh.jswat.view;

import java.awt.event.MouseEvent;

/**
 * Producers of tooltips for the source view text area must implement
 * this interface.
 *
 * @author  Nathan Fiedler
 */
public interface TooltipProducer {
    // The lower the priority number, the higher the precedence.
    // Otherwise we would have to reverse the list in order for the
    // higher precedence draw layers to draw last.

    /** Lowest producer priority. */
    public static final int PRIORITY_LOWEST = 512;
    /** Highest producer priority. */
    public static final int PRIORITY_HIGHEST = 64;

    /**
     * Gets the priority level of this particular tooltip producer.
     * Typically each type of producer has its own priority. Lower
     * values are higher priority.
     *
     * @return  priority level.
     */
    int getPriority();

    /**
     * Generate the appropriate tooltip for the given mouse event.
     *
     * @param  event  the event that caused the tooltip to appear.
     * @param  area   source view text area making the request.
     * @return  the tooltip, or null if none.
     */
    String produceTooltip(MouseEvent event, SourceViewTextArea area);
} // TooltipProducer
