/*********************************************************************
 *
 *      Copyright (C) 2002-2003 Nathan Fiedler
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: ActiveTests.java 1088 2003-12-05 01:44:55Z nfiedler $
 *
 ********************************************************************/

package com.bluemarsh.jswat.command;

import com.bluemarsh.jswat.SessionSetup;
import junit.extensions.*;
import junit.framework.*;

/**
 * Runs all of the JSwat active command tests.
 */
public class ActiveTests {

    public static Test suite() {
        TestSuite suite = new TestSuite("JSwat Active Command Tests");
        suite.addTest(ActiveCases.suite());
        suite.addTest(ActiveFailCases.suite());
        return new SessionSetup(suite, true);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }
}
