/*
 * This file is part of "The Java Telnet Application".
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * "The Java Telnet Application" is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
package de.mud.jta.event;

import de.mud.jta.PluginListener;
import java.io.IOException;

/**
 * This interface should be used by plugins who would like to be notified
 * about the end of record event
 * <P>
 * <B>Maintainer:</B> Marcus Meissner
 *
 * @version $Id: TelnetCommandListener.java,v 1.2 2000/12/03 17:13:52 marcus Exp $
 * @author Matthias L. Jugel, Marcus Meiner
 */
public interface TelnetCommandListener extends PluginListener {
  /** Called by code in the terminal interface or somewhere for sending
   * telnet commands
   */
  public void sendTelnetCommand(byte command) throws IOException;
}
