/***************************************************************************
 *   Copyright (C) 2003-2005 by Kevin Hessels                              *
 *   khessels@shaw.ca                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <qlayout.h>
#include <qtimer.h>

#include <kdebug.h>
#include <kdialogbase.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kpushbutton.h>

#include "kfoldingconfigdata.h"
#include "kfoldingdisplaywidgetimpl.h"
#include "kfoldingmoleculewidget.h"
#include "kfoldingunitdialog.h"


kfoldingUnitDialog::kfoldingUnitDialog( QWidget* parent, const char* name, const QString& caption, kfoldingConfigData* cfg )
	: KDialogBase( Plain, caption, Close, Ok,  parent, name, false ),
	  _configData( cfg )
{
	if ( !_configData )
		return;

	setIcon( SmallIcon( "kfolding" ) );
	resize( 800, 600 );

	QTimer::singleShot( 0, this, SLOT( slotSetupWidgets() ) );
	return;
} // kfoldingUnitDialog ctor


kfoldingUnitDialog::~kfoldingUnitDialog()
{
	return;
} // kfoldingUnitInfoWidget dtor


void kfoldingUnitDialog::slotDrawComplete()
{
	_displayWidget->setEnabled( true );
	return;
} // slotDrawComplete


void kfoldingUnitDialog::slotRedraw()
{
	_displayWidget->saveOptions();
	_displayWidget->setEnabled( false );
	_moleculeWidget->setOptions();
	_moleculeWidget->update();
	return;
} // slotRedraw


void kfoldingUnitDialog::slotSetupWidgets()
{
	QFrame *frame = plainPage();
	QHBoxLayout *hbox = new QHBoxLayout( frame );
	
	_displayWidget = new kfoldingDisplayWidgetImpl( frame, "displayWidget", _configData );
	_displayWidget->setSizePolicy( QSizePolicy::Fixed, QSizePolicy::Preferred );
	_displayWidget->setEnabled( false );
	
	_moleculeWidget = new kfoldingMoleculeWidget( frame, "moleculeWidget", _configData );
	_moleculeWidget->setSizePolicy( QSizePolicy::Preferred, QSizePolicy::Expanding );

	hbox->addWidget( _displayWidget );
	hbox->addWidget( _moleculeWidget );
	
	_displayWidget->show();
	_moleculeWidget->show();

	connect( _displayWidget->zoomIn, SIGNAL( clicked() ), this, SLOT( slotZoomIn() ) );
	connect( _displayWidget->zoomOut, SIGNAL( clicked() ), this, SLOT( slotZoomOut() ) );
	connect( _displayWidget->redraw, SIGNAL( clicked() ), this, SLOT( slotRedraw() ) );
	connect( _moleculeWidget, SIGNAL( drawComplete() ), this, SLOT( slotDrawComplete() ) );
	return;
} // setupWidgets


void kfoldingUnitDialog::slotZoomIn()
{
	_displayWidget->setEnabled( false );
	_moleculeWidget->zoomIn();
	return;
} // slotZoomIn


void kfoldingUnitDialog::slotZoomOut()
{
	_displayWidget->setEnabled( false );
	_moleculeWidget->zoomOut();
	return;
} // slotZoomOut


#include "kfoldingunitdialog.moc"
