/***************************************************************************
                          tripletscreen.cpp  -  description
                             -------------------
    begin                : Sat Feb 16 2002
    copyright            : (C) 2002 by Sebastian Schildt
    email                : sebastian@frozenlight.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tripletscreen.h"



void TripletScreen::paintScreen(QPainter *p, QWidget *rpt, setiparse *s, paintHelpers *ph) {

	QPointArray triangleCoords;

  ph->clearScreen(p);
	ph->drawMainHeader(p,"Signal detected: Triplet");
	
	trp = s->getTriplet();

	graph = plotTriplet(trp);
	p->drawPixmap(10,85,graph);
	int pw = graph.width();
	p->flush();
	
	QString qtmp;
	p->setFont(ph->mediumFont);
	p->setPen(ph->lcarsLila);
	ph->sound->playBeep1();
	p->drawText(pw+30,120,"Displaying signal characteristics");
	p->flush();

	p->setPen(ph->lcarsOrange);
	usleep(800000);
	qtmp.sprintf("Detected with a chirprate of %.3f Hz",trp.chirpRate);
	ph->sound->playBeep2();
	p->drawText(pw+30,150,qtmp);
	/*Mark first spike */
	triangleCoords.setPoints(3, (2*trp.peak1)+6,75 , 2*(trp.peak1)+16,75 , (2*trp.peak1)+11,85 );
	p->setPen(ph->lgray);
  p->setBrush(ph->lgray);
	p->drawPolygon(triangleCoords);
	p->flush();

	usleep(400000);
	p->setPen(ph->lcarsOrange);
	qtmp.sprintf("Signal strength: %.3f",trp.power);
	ph->sound->playBeep2();
	p->drawText(pw+30,175,qtmp);
	/*Mark second spike */
	triangleCoords.setPoints(3, (2*trp.peak2)+6,75 , 2*(trp.peak2)+16,75 , (2*trp.peak2)+11,85 );
	p->setPen(ph->lgray);
  p->drawPolygon(triangleCoords);
	p->flush();

	usleep(400000);
	p->setPen(ph->lcarsOrange);
	qtmp.sprintf("Pulse period: %.3f s",trp.period);
	ph->sound->playBeep2();
	p->drawText(pw+30,200,qtmp);
	/*Mark third spike */
	triangleCoords.setPoints(3, (2*trp.peak3)+6,75 , 2*(trp.peak3)+16,75 , (2*trp.peak3)+11,85 );
	p->setPen(ph->lgray);
  p->drawPolygon(triangleCoords);
	
	p->flush();

  usleep(400000);
	p->setPen(ph->lcarsOrange);
	qtmp.sprintf("Signal length: %d",trp.fftLen);
	ph->sound->playBeep2();
	p->drawText(pw+30,225,qtmp);
	p->flush();

	usleep(400000);
	qtmp = "Data segment ";
	qtmp = qtmp + s->getWu_name().c_str();
	qtmp = qtmp + " will be saved for further analysis.";
	ph->sound->playBeep2();
	p->drawText(10,340,qtmp);
	p->flush();

	
	usleep(800000);

	p->setFont(ph->headerfont);
	QFontMetrics fm(ph->headerfont);
	double art =  trp.score/100;
	//qtmp.sprintf("Signal artificial with a probability of %.3f %%",art);
	qtmp.sprintf("Signal quality index is %.3f",art);
	int border = (1024- fm.width(qtmp))/2;
	ph->sound->playBeep2();
	p->drawText(border,650,qtmp,23);
	qtmp.sprintf("%.3f",art);
	int fromLeft = 1024-(border+fm.width(qtmp));
	for (int i = 0; i <= 12; i++) {
		if (i % 2 == 0) {
			p->setPen(ph->lcarsOrange);
			p->drawText( fromLeft,650,qtmp );
		}
		else {
			p->setPen(Qt::black);
			p->fillRect(fromLeft,600,1024-fromLeft,100,Qt::black);
		}
		p->flush();
		usleep(800000);
	}
	
	//sleep(7);
}


QPixmap TripletScreen::plotTriplet(Triplet t) {

    QPixmap tmp(t.dataLen,200);
		//cout << "datlen " << t.dataLen << endl;
		tmp.fill(Qt::black);

		double max = 0;
		for (int i = 0; i < t.dataLen; i++) {
     	if (t.data[i] > max) { max = t.data[i]; }
		}
		//cout << "Max is " << max << endl;

		QColor redcol(255,0,0);
		QPainter pnt(&tmp);

		double factor = 200 / max;
		int prevHeight = (int) (t.data[0] * factor);
		int height;
		pnt.setPen(QPen(redcol));
		for (int i = 0; i < t.dataLen; i++) {
   		height = (int) (t.data[i]*factor);
			pnt.drawLine(i*1,199-prevHeight,i*1,199-height);
			pnt.drawLine(i*1,199-height,(i*1)+1,199-height);
			prevHeight=height;
		}
		return tmp;
}
