/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class DefaultDesktopManager
implements DesktopManager,
Serializable {
    static final String PREVIOUS_BOUNDS_PROPERTY = "previousBounds";
    static final String HAS_BEEN_ICONIFIED_PROPERTY = "wasIconOnce";
    static final int DEFAULT_DRAG_MODE = 0;
    static final int OUTLINE_DRAG_MODE = 1;
    static final int FASTER_DRAG_MODE = 2;
    int dragMode = 0;
    private static JInternalFrame currentActiveFrame = null;
    private transient Rectangle currentBounds = null;
    private transient Graphics desktopGraphics = null;
    private transient Rectangle desktopBounds = null;
    private transient Rectangle[] floatingItems = new Rectangle[0];
    private transient Point currentLoc = null;

    public void activateFrame(JInternalFrame jInternalFrame) {
        Container container = jInternalFrame.getParent();
        if (container == null && (container = jInternalFrame.getDesktopIcon().getParent()) == null) {
            return;
        }
        if (currentActiveFrame == null) {
            currentActiveFrame = jInternalFrame;
        } else if (currentActiveFrame != jInternalFrame) {
            if (currentActiveFrame.isSelected()) {
                try {
                    currentActiveFrame.setSelected(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
            currentActiveFrame = jInternalFrame;
        }
        jInternalFrame.moveToFront();
    }

    public void beginDraggingFrame(JComponent jComponent) {
        this.setupDragMode(jComponent);
        if (this.dragMode == 2) {
            this.floatingItems = this.findFloatingItems(jComponent);
            this.currentBounds = jComponent.getBounds();
            this.desktopBounds = jComponent.getParent().getBounds();
            this.desktopBounds.x = 0;
            this.desktopBounds.y = 0;
            this.desktopGraphics = jComponent.getParent().getGraphics();
            ((JInternalFrame)jComponent).isDragging = true;
        }
    }

    public void beginResizingFrame(JComponent jComponent, int n) {
        this.setupDragMode(jComponent);
    }

    public void closeFrame(JInternalFrame jInternalFrame) {
        if (jInternalFrame.getParent() != null) {
            Container container = jInternalFrame.getParent();
            container.remove(jInternalFrame);
            container.repaint(jInternalFrame.getX(), jInternalFrame.getY(), jInternalFrame.getWidth(), jInternalFrame.getHeight());
        }
        this.removeIconFor(jInternalFrame);
        if (this.getPreviousBounds(jInternalFrame) != null) {
            this.setPreviousBounds(jInternalFrame, null);
        }
        if (this.wasIcon(jInternalFrame)) {
            this.setWasIcon(jInternalFrame, null);
        }
    }

    public void deactivateFrame(JInternalFrame jInternalFrame) {
        if (currentActiveFrame == jInternalFrame) {
            currentActiveFrame = null;
        }
    }

    public void deiconifyFrame(JInternalFrame jInternalFrame) {
        block2: {
            JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
            if (jDesktopIcon.getParent() == null) break block2;
            jDesktopIcon.getParent().add(jInternalFrame);
            this.removeIconFor(jInternalFrame);
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    public void dragFrame(JComponent jComponent, int n, int n2) {
        if (this.dragMode == 1) {
            JDesktopPane jDesktopPane = this.getDesktopPane(jComponent);
            if (jDesktopPane != null) {
                Graphics graphics = jDesktopPane.getGraphics();
                graphics.setXORMode(Color.white);
                if (this.currentLoc != null) {
                    graphics.drawRect(this.currentLoc.x, this.currentLoc.y, jComponent.getWidth() - 1, jComponent.getHeight() - 1);
                }
                graphics.drawRect(n, n2, jComponent.getWidth() - 1, jComponent.getHeight() - 1);
                this.currentLoc = new Point(n, n2);
                graphics.setPaintMode();
            }
        } else if (this.dragMode == 2) {
            this.dragFrameFaster(jComponent, n, n2);
        } else {
            this.setBoundsForFrame(jComponent, n, n2, jComponent.getWidth(), jComponent.getHeight());
        }
    }

    private void dragFrameFaster(JComponent jComponent, int n, int n2) {
        Rectangle rectangle = new Rectangle(this.currentBounds.x, this.currentBounds.y, this.currentBounds.width, this.currentBounds.height);
        this.currentBounds.x = n;
        this.currentBounds.y = n2;
        if (this.isFloaterCollision(rectangle, this.currentBounds)) {
            this.setBoundsForFrame(jComponent, n, n2, jComponent.getWidth(), jComponent.getHeight());
            return;
        }
        this.emergencyCleanup(jComponent);
        Rectangle rectangle2 = rectangle.intersection(this.desktopBounds);
        this.desktopGraphics.copyArea(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, n - rectangle.x, n2 - rectangle.y);
        jComponent.setBounds(this.currentBounds);
        RepaintManager repaintManager = RepaintManager.currentManager(jComponent);
        JComponent jComponent2 = (JComponent)jComponent.getParent();
        repaintManager.markCompletelyClean(jComponent2);
        repaintManager.markCompletelyClean(jComponent);
        Rectangle[] rectangleArray = null;
        rectangleArray = rectangle.intersects(this.currentBounds) ? SwingUtilities.computeDifference(rectangle, this.currentBounds) : new Rectangle[]{rectangle};
        int n3 = 0;
        while (n3 < rectangleArray.length) {
            jComponent2.paintImmediately(rectangleArray[n3]);
            ++n3;
        }
        if (!rectangle2.equals(rectangle)) {
            rectangleArray = SwingUtilities.computeDifference(rectangle, this.desktopBounds);
            int n4 = 0;
            while (n4 < rectangleArray.length) {
                rectangleArray[n4].x += n - rectangle.x;
                rectangleArray[n4].y += n2 - rectangle.y;
                ((JInternalFrame)jComponent).isDragging = false;
                jComponent2.paintImmediately(rectangleArray[n4]);
                ((JInternalFrame)jComponent).isDragging = true;
                ++n4;
            }
        }
    }

    private void emergencyCleanup(final JComponent jComponent) {
        if (((JInternalFrame)jComponent).danger) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((JInternalFrame)jComponent).isDragging = false;
                    jComponent.paintImmediately(0, 0, jComponent.getWidth(), jComponent.getHeight());
                    ((JInternalFrame)jComponent).isDragging = true;
                }
            });
            ((JInternalFrame)jComponent).danger = false;
        }
    }

    public void endDraggingFrame(JComponent jComponent) {
        if (this.dragMode == 1 && this.currentLoc != null) {
            this.setBoundsForFrame(jComponent, this.currentLoc.x, this.currentLoc.y, jComponent.getWidth(), jComponent.getHeight());
            this.currentLoc = null;
        } else if (this.dragMode == 2) {
            this.currentBounds = null;
            this.desktopGraphics = null;
            this.desktopBounds = null;
            ((JInternalFrame)jComponent).isDragging = false;
        }
    }

    public void endResizingFrame(JComponent jComponent) {
        if (this.dragMode == 1 && this.currentBounds != null) {
            this.setBoundsForFrame(jComponent, this.currentBounds.x, this.currentBounds.y, this.currentBounds.width, this.currentBounds.height);
            this.currentBounds = null;
        }
    }

    private Rectangle[] findFloatingItems(JComponent jComponent) {
        Container container = jComponent.getParent();
        Component[] componentArray = container.getComponents();
        int n = 0;
        n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] == jComponent) break;
            ++n;
        }
        Rectangle[] rectangleArray = new Rectangle[n];
        n = 0;
        while (n < rectangleArray.length) {
            rectangleArray[n] = componentArray[n].getBounds();
            ++n;
        }
        return rectangleArray;
    }

    protected Rectangle getBoundsForIconOf(JInternalFrame jInternalFrame) {
        Container container = jInternalFrame.getParent();
        Rectangle rectangle = container.getBounds();
        Component[] componentArray = container.getComponents();
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        Dimension dimension = jDesktopIcon.getPreferredSize();
        Rectangle rectangle2 = null;
        Component component = null;
        int n = 0;
        int n2 = rectangle.height - dimension.height;
        int n3 = dimension.width;
        int n4 = dimension.height;
        boolean bl = false;
        while (!bl) {
            rectangle2 = new Rectangle(n, n2, n3, n4);
            bl = true;
            int n5 = 0;
            while (n5 < componentArray.length) {
                if (componentArray[n5] instanceof JInternalFrame) {
                    component = ((JInternalFrame)componentArray[n5]).getDesktopIcon();
                } else if (componentArray[n5] instanceof JInternalFrame.JDesktopIcon) {
                    component = (JInternalFrame.JDesktopIcon)componentArray[n5];
                }
                if (!component.equals(jDesktopIcon) && rectangle2.intersects(component.getBounds())) {
                    bl = false;
                    break;
                }
                ++n5;
            }
            if ((n += component.getBounds().width) + n3 <= rectangle.width) continue;
            n = 0;
            n2 -= n4;
        }
        return rectangle2;
    }

    JDesktopPane getDesktopPane(JComponent jComponent) {
        JDesktopPane jDesktopPane = null;
        Container container = jComponent.getParent();
        while (jDesktopPane == null) {
            if (container instanceof JDesktopPane) {
                jDesktopPane = (JDesktopPane)container;
                continue;
            }
            if (container == null) break;
            container = container.getParent();
        }
        return jDesktopPane;
    }

    protected Rectangle getPreviousBounds(JInternalFrame jInternalFrame) {
        return (Rectangle)jInternalFrame.getClientProperty(PREVIOUS_BOUNDS_PROPERTY);
    }

    public void iconifyFrame(JInternalFrame jInternalFrame) {
        Container container;
        Serializable serializable;
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        if (!this.wasIcon(jInternalFrame)) {
            serializable = this.getBoundsForIconOf(jInternalFrame);
            jDesktopIcon.setBounds(serializable.x, serializable.y, serializable.width, serializable.height);
            this.setWasIcon(jInternalFrame, Boolean.TRUE);
        }
        if ((container = jInternalFrame.getParent()) instanceof JLayeredPane) {
            serializable = (JLayeredPane)container;
            int n = JLayeredPane.getLayer(jInternalFrame);
            JLayeredPane.putLayer(jDesktopIcon, n);
        }
        container.remove(jInternalFrame);
        container.add(jDesktopIcon);
        container.repaint(jInternalFrame.getX(), jInternalFrame.getY(), jInternalFrame.getWidth(), jInternalFrame.getHeight());
        try {
            jInternalFrame.setSelected(false);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    private boolean isFloaterCollision(Rectangle rectangle, Rectangle rectangle2) {
        if (this.floatingItems.length == 0) {
            return false;
        }
        int n = 0;
        while (n < this.floatingItems.length) {
            boolean bl = rectangle.intersects(this.floatingItems[n]);
            if (bl) {
                return true;
            }
            boolean bl2 = rectangle2.intersects(this.floatingItems[n]);
            if (bl2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void maximizeFrame(JInternalFrame jInternalFrame) {
        Rectangle rectangle;
        if (!jInternalFrame.isIcon()) {
            this.setPreviousBounds(jInternalFrame, jInternalFrame.getBounds());
            rectangle = jInternalFrame.getParent().getBounds();
        } else {
            Container container = jInternalFrame.getDesktopIcon().getParent();
            if (container == null) {
                return;
            }
            rectangle = container.getBounds();
            try {
                jInternalFrame.setIcon(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        this.setBoundsForFrame(jInternalFrame, 0, 0, rectangle.width, rectangle.height);
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.removeIconFor(jInternalFrame);
    }

    public void minimizeFrame(JInternalFrame jInternalFrame) {
        if (this.getPreviousBounds(jInternalFrame) != null) {
            Rectangle rectangle = this.getPreviousBounds(jInternalFrame);
            this.setPreviousBounds(jInternalFrame, null);
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
            if (jInternalFrame.isIcon()) {
                try {
                    jInternalFrame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
            this.setBoundsForFrame(jInternalFrame, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.removeIconFor(jInternalFrame);
    }

    public void openFrame(JInternalFrame jInternalFrame) {
        if (jInternalFrame.getDesktopIcon().getParent() != null) {
            jInternalFrame.getDesktopIcon().getParent().add(jInternalFrame);
            this.removeIconFor(jInternalFrame);
        }
    }

    protected void removeIconFor(JInternalFrame jInternalFrame) {
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        Container container = jDesktopIcon.getParent();
        if (container != null) {
            container.remove(jDesktopIcon);
            container.repaint(jDesktopIcon.getX(), jDesktopIcon.getY(), jDesktopIcon.getWidth(), jDesktopIcon.getHeight());
        }
    }

    public void resizeFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
        if (this.dragMode == 0 || this.dragMode == 2) {
            this.setBoundsForFrame(jComponent, n, n2, n3, n4);
        } else {
            JDesktopPane jDesktopPane = this.getDesktopPane(jComponent);
            if (jDesktopPane != null) {
                Graphics graphics = jDesktopPane.getGraphics();
                graphics.setXORMode(Color.white);
                if (this.currentBounds != null) {
                    graphics.drawRect(this.currentBounds.x, this.currentBounds.y, this.currentBounds.width - 1, this.currentBounds.height - 1);
                }
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                this.currentBounds = new Rectangle(n, n2, n3, n4);
                graphics.setPaintMode();
            }
        }
    }

    public void setBoundsForFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
        boolean bl = jComponent.getWidth() != n3 || jComponent.getHeight() != n4;
        jComponent.setBounds(n, n2, n3, n4);
        if (bl) {
            jComponent.validate();
        }
    }

    protected void setPreviousBounds(JInternalFrame jInternalFrame, Rectangle rectangle) {
        if (rectangle != null) {
            jInternalFrame.putClientProperty(PREVIOUS_BOUNDS_PROPERTY, rectangle);
        }
    }

    protected void setWasIcon(JInternalFrame jInternalFrame, Boolean bl) {
        if (bl != null) {
            jInternalFrame.putClientProperty(HAS_BEEN_ICONIFIED_PROPERTY, bl);
        }
    }

    private void setupDragMode(JComponent jComponent) {
        JDesktopPane jDesktopPane = this.getDesktopPane(jComponent);
        if (jDesktopPane != null) {
            String string = (String)jDesktopPane.getClientProperty("JDesktopPane.dragMode");
            this.dragMode = string != null && string.equals("outline") ? 1 : (string != null && string.equals("faster") && jComponent instanceof JInternalFrame ? 2 : 0);
        }
    }

    protected boolean wasIcon(JInternalFrame jInternalFrame) {
        return jInternalFrame.getClientProperty(HAS_BEEN_ICONIFIED_PROPERTY) == Boolean.TRUE;
    }
}

