/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Image;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.LabelUI;

public class JLabel
extends JComponent
implements SwingConstants,
Accessible {
    private static final String uiClassID = "LabelUI";
    private int mnemonic = 0;
    private String text = "";
    private Icon defaultIcon = null;
    private Icon disabledIcon = null;
    private boolean disabledIconSet = false;
    private int verticalAlignment = 0;
    private int horizontalAlignment = 10;
    private int verticalTextPosition = 0;
    private int horizontalTextPosition = 11;
    private int iconTextGap = 4;
    protected Component labelFor = null;
    static final String LABELED_BY_PROPERTY = "labeledBy";

    public JLabel() {
        this("", null, 10);
    }

    public JLabel(String string) {
        this(string, null, 10);
    }

    public JLabel(String string, int n) {
        this(string, null, n);
    }

    public JLabel(String string, Icon icon, int n) {
        this.setText(string);
        this.setIcon(icon);
        this.setHorizontalAlignment(n);
        this.updateUI();
        this.setAlignmentX(0.0f);
    }

    public JLabel(Icon icon) {
        this(null, icon, 0);
    }

    public JLabel(Icon icon, int n) {
        this(null, icon, n);
    }

    protected int checkHorizontalKey(int n, String string) {
        if (n == 2 || n == 0 || n == 4 || n == 10 || n == 11) {
            return n;
        }
        throw new IllegalArgumentException(string);
    }

    protected int checkVerticalKey(int n, String string) {
        if (n == 1 || n == 0 || n == 3) {
            return n;
        }
        throw new IllegalArgumentException(string);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJLabel();
        }
        return this.accessibleContext;
    }

    public Icon getDisabledIcon() {
        if (!this.disabledIconSet && this.disabledIcon == null && this.defaultIcon != null && this.defaultIcon instanceof ImageIcon) {
            Image image = GrayFilter.createDisabledImage(((ImageIcon)this.defaultIcon).getImage());
            this.disabledIcon = new ImageIcon(image);
            this.firePropertyChange("disabledIcon", null, this.disabledIcon);
        }
        return this.disabledIcon;
    }

    public int getDisplayedMnemonic() {
        return this.mnemonic;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    public Icon getIcon() {
        return this.defaultIcon;
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public Component getLabelFor() {
        return this.labelFor;
    }

    public String getText() {
        return this.text;
    }

    public LabelUI getUI() {
        return (LabelUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public int getVerticalTextPosition() {
        return this.verticalTextPosition;
    }

    protected String paramString() {
        String string;
        String string2 = this.text != null ? this.text : "";
        String string3 = this.defaultIcon != null ? this.defaultIcon.toString() : "";
        String string4 = this.disabledIcon != null ? this.disabledIcon.toString() : "";
        String string5 = string = this.labelFor != null ? this.labelFor.toString() : "";
        String string6 = this.verticalAlignment == 1 ? "TOP" : (this.verticalAlignment == 0 ? "CENTER" : (this.verticalAlignment == 3 ? "BOTTOM" : ""));
        String string7 = this.horizontalAlignment == 2 ? "LEFT" : (this.horizontalAlignment == 0 ? "CENTER" : (this.horizontalAlignment == 4 ? "RIGHT" : ""));
        String string8 = this.verticalTextPosition == 1 ? "TOP" : (this.verticalTextPosition == 0 ? "CENTER" : (this.verticalTextPosition == 3 ? "BOTTOM" : ""));
        String string9 = this.horizontalTextPosition == 2 ? "LEFT" : (this.horizontalTextPosition == 0 ? "CENTER" : (this.horizontalTextPosition == 4 ? "RIGHT" : ""));
        return String.valueOf(super.paramString()) + ",defaultIcon=" + string3 + ",disabledIcon=" + string4 + ",horizontalAlignment=" + string7 + ",horizontalTextPosition=" + string9 + ",iconTextGap=" + this.iconTextGap + ",labelFor=" + string + ",text=" + string2 + ",verticalAlignment=" + string6 + ",verticalTextPosition=" + string8;
    }

    public void setDisabledIcon(Icon icon) {
        Icon icon2 = this.disabledIcon;
        this.disabledIcon = icon;
        this.disabledIconSet = true;
        this.firePropertyChange("disabledIcon", icon2, icon);
        if (icon != icon2) {
            if (icon == null || icon2 == null || icon.getIconWidth() != icon2.getIconWidth() || icon.getIconHeight() != icon2.getIconHeight()) {
                this.revalidate();
            }
            if (!this.isEnabled()) {
                this.repaint();
            }
        }
    }

    public void setDisplayedMnemonic(char n) {
        int n2 = n;
        if (n2 >= 97 && n2 <= 122) {
            n2 -= 32;
        }
        this.setDisplayedMnemonic(n2);
    }

    public void setDisplayedMnemonic(int n) {
        int n2 = this.mnemonic;
        this.mnemonic = n;
        this.firePropertyChange("displayedMnemonic", n2, this.mnemonic);
        if (n != n2) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setHorizontalAlignment(int n) {
        if (n == this.horizontalAlignment) {
            return;
        }
        int n2 = this.horizontalAlignment;
        this.horizontalAlignment = this.checkHorizontalKey(n, "horizontalAlignment");
        this.firePropertyChange("horizontalAlignment", n2, this.horizontalAlignment);
        this.repaint();
    }

    public void setHorizontalTextPosition(int n) {
        int n2 = this.horizontalTextPosition;
        this.horizontalTextPosition = this.checkHorizontalKey(n, "horizontalTextPosition");
        this.firePropertyChange("horizontalTextPosition", n2, this.horizontalTextPosition);
        this.repaint();
    }

    public void setIcon(Icon icon) {
        Icon icon2 = this.defaultIcon;
        this.defaultIcon = icon;
        if (this.defaultIcon != icon2 && !this.disabledIconSet) {
            this.disabledIcon = null;
        }
        this.firePropertyChange("icon", icon2, this.defaultIcon);
        if (this.accessibleContext != null && icon2 != this.defaultIcon) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, this.defaultIcon);
        }
        if (this.defaultIcon != icon2) {
            if (this.defaultIcon == null || icon2 == null || this.defaultIcon.getIconWidth() != icon2.getIconWidth() || this.defaultIcon.getIconHeight() != icon2.getIconHeight()) {
                this.revalidate();
            }
            this.repaint();
        }
    }

    public void setIconTextGap(int n) {
        int n2 = this.iconTextGap;
        this.iconTextGap = n;
        this.firePropertyChange("iconTextGap", n2, n);
        if (n != n2) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setLabelFor(Component component) {
        Component component2 = this.labelFor;
        this.labelFor = component;
        this.firePropertyChange("labelFor", component2, component);
        if (component2 instanceof JComponent) {
            ((JComponent)component2).putClientProperty(LABELED_BY_PROPERTY, null);
        }
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty(LABELED_BY_PROPERTY, this);
        }
    }

    public void setText(String string) {
        String string2 = null;
        if (this.accessibleContext != null) {
            string2 = this.accessibleContext.getAccessibleName();
        }
        String string3 = this.text;
        this.text = string;
        this.firePropertyChange("text", string3, string);
        if (this.accessibleContext != null && this.accessibleContext.getAccessibleName() != string2) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, this.accessibleContext.getAccessibleName());
        }
        if (string == null || string3 == null || !string.equals(string3)) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setUI(LabelUI labelUI) {
        super.setUI(labelUI);
    }

    public void setVerticalAlignment(int n) {
        if (n == this.verticalAlignment) {
            return;
        }
        int n2 = this.verticalAlignment;
        this.verticalAlignment = this.checkVerticalKey(n, "verticalAlignment");
        this.firePropertyChange("verticalAlignment", n2, this.verticalAlignment);
        this.repaint();
    }

    public void setVerticalTextPosition(int n) {
        if (n == this.verticalTextPosition) {
            return;
        }
        int n2 = this.verticalTextPosition;
        this.verticalTextPosition = this.checkVerticalKey(n, "verticalTextPosition");
        this.firePropertyChange("verticalTextPosition", n2, this.verticalTextPosition);
        this.repaint();
    }

    public void updateUI() {
        this.setUI((LabelUI)UIManager.getUI(this));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    protected class AccessibleJLabel
    extends JComponent.AccessibleJComponent {
        protected AccessibleJLabel() {
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (JLabel.this.getText() == null) {
                return super.getAccessibleName();
            }
            return JLabel.this.getText();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

