/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.plaf.ComponentUI;

public class UIDefaults
extends Hashtable {
    private static final Object PENDING = new String("Pending");
    private SwingPropertyChangeSupport changeSupport;
    static /* synthetic */ Class class$javax$swing$JComponent;

    public UIDefaults() {
    }

    public UIDefaults(Object[] objectArray) {
        super(objectArray.length / 2);
        int n = 0;
        while (n < objectArray.length) {
            super.put(objectArray[n], objectArray[n + 1]);
            n += 2;
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object get(Object object) {
        Object object2 = super.get(object);
        if (object2 != PENDING && !(object2 instanceof ActiveValue) && !(object2 instanceof LazyValue)) {
            return object2;
        }
        UIDefaults uIDefaults = this;
        synchronized (uIDefaults) {
            object2 = super.get(object);
            if (object2 == PENDING) {
                do {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } while ((object2 = super.get(object)) == PENDING);
                return object2;
            }
            if (object2 instanceof LazyValue) {
                super.put(object, PENDING);
            } else if (!(object2 instanceof ActiveValue)) {
                return object2;
            }
        }
        if (!(object2 instanceof LazyValue)) return ((ActiveValue)object2).createValue(this);
        try {
            object2 = ((LazyValue)object2).createValue(this);
        }
        catch (Throwable throwable) {
            uIDefaults = null;
            UIDefaults uIDefaults2 = this;
            synchronized (uIDefaults2) {
                if (object2 == null) {
                    super.remove(object);
                } else {
                    super.put(object, object2);
                }
                this.notify();
                throw throwable;
            }
        }
        uIDefaults = null;
        UIDefaults uIDefaults3 = this;
        synchronized (uIDefaults3) {
            if (object2 == null) {
                super.remove(object);
            } else {
                super.put(object, object2);
            }
            this.notify();
            return object2;
        }
    }

    public Border getBorder(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Border ? (Border)object2 : null;
    }

    public Color getColor(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Color ? (Color)object2 : null;
    }

    public Dimension getDimension(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Dimension ? (Dimension)object2 : null;
    }

    public Font getFont(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Font ? (Font)object2 : null;
    }

    public Icon getIcon(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Icon ? (Icon)object2 : null;
    }

    public Insets getInsets(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Insets ? (Insets)object2 : null;
    }

    public int getInt(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Integer ? (Integer)object2 : 0;
    }

    public String getString(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof String ? (String)object2 : null;
    }

    public ComponentUI getUI(JComponent jComponent) {
        Object object = this.get("ClassLoader");
        ClassLoader classLoader = object != null ? (ClassLoader)object : jComponent.getClass().getClassLoader();
        Class clazz = this.getUIClass(jComponent.getUIClassID(), classLoader);
        Object object2 = null;
        if (clazz == null) {
            this.getUIError("no ComponentUI class for: " + jComponent);
        } else {
            try {
                Method method = (Method)this.get(clazz);
                if (method == null) {
                    Class clazz2 = class$javax$swing$JComponent != null ? class$javax$swing$JComponent : (class$javax$swing$JComponent = UIDefaults.class$("javax.swing.JComponent"));
                    method = clazz.getMethod("createUI", clazz2);
                    this.put(clazz, method);
                }
                object2 = method.invoke(null, jComponent);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.getUIError("static createUI() method not found in " + clazz);
            }
            catch (Exception exception) {
                this.getUIError("createUI() failed for " + jComponent + " " + exception);
            }
        }
        return (ComponentUI)object2;
    }

    public Class getUIClass(String string) {
        return this.getUIClass(string, null);
    }

    public Class getUIClass(String string, ClassLoader classLoader) {
        try {
            String string2 = (String)this.get(string);
            Class<Object> clazz = (Class<?>)this.get(string2);
            if (clazz == null && (clazz = classLoader == null ? SwingUtilities.loadSystemClass(string2) : classLoader.loadClass(string2)) != null) {
                this.put(string2, clazz);
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    protected void getUIError(String string) {
        System.err.println("UIDefaults.getUI() failed: " + string);
        try {
            throw new Error();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public Object put(Object object, Object object2) {
        Object object3;
        Object object4 = object3 = object2 == null ? super.remove(object) : super.put(object, object2);
        if (object instanceof String) {
            this.firePropertyChange((String)object, object3, object2);
        }
        return object3;
    }

    public void putDefaults(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n + 1];
            if (object == null) {
                super.remove(objectArray[n]);
            } else {
                super.put(objectArray[n], object);
            }
            n += 2;
        }
        this.firePropertyChange("UIDefaults", null, null);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public static interface LazyValue {
        public Object createValue(UIDefaults var1);
    }

    public static interface ActiveValue {
        public Object createValue(UIDefaults var1);
    }
}

