/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalToolTipUI
extends BasicToolTipUI {
    static MetalToolTipUI sharedInstance = new MetalToolTipUI();
    Font smallFont;
    static JToolTip tip;
    public static final int padSpaceBetweenStrings = 12;

    public static ComponentUI createUI(JComponent jComponent) {
        return sharedInstance;
    }

    public String getAcceleratorString() {
        JComponent jComponent = tip.getComponent();
        if (jComponent == null) {
            return "";
        }
        KeyStroke[] keyStrokeArray = jComponent.getRegisteredKeyStrokes();
        String string = "";
        int n = 0;
        while (n < keyStrokeArray.length) {
            char c = (char)keyStrokeArray[n].getKeyCode();
            int n2 = keyStrokeArray[n].getModifiers();
            int n3 = jComponent.getConditionForKeyStroke(keyStrokeArray[n]);
            if (n2 == 2 && n3 == 2) {
                string = "cntl+" + (char)keyStrokeArray[n].getKeyCode();
                break;
            }
            if (n2 == 8 && n3 == 2) {
                string = "alt+" + (char)keyStrokeArray[n].getKeyCode();
                break;
            }
            ++n;
        }
        return string;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        String string = this.getAcceleratorString();
        if (!string.equals("")) {
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.smallFont);
            dimension.width += fontMetrics.stringWidth(string) + 12;
        }
        return dimension;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        tip = (JToolTip)jComponent;
        Font font = jComponent.getFont();
        this.smallFont = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        String string = this.getAcceleratorString();
        String string2 = ((JToolTip)jComponent).getTipText();
        if (string2 == null) {
            string2 = "";
        }
        if (!string.equals("")) {
            graphics.setFont(this.smallFont);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawString(string, fontMetrics.stringWidth(string2) + 3 + 12, 2 + fontMetrics.getAscent());
        }
    }
}

