/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.io.Serializable;
import java.util.BitSet;
import javax.swing.DefaultListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.html.Option;

class OptionListModel
extends DefaultListModel
implements ListSelectionModel,
Serializable {
    private static final int MIN = -1;
    private static final int MAX = Integer.MAX_VALUE;
    private int selectionMode = 0;
    private int minIndex = Integer.MAX_VALUE;
    private int maxIndex = -1;
    private int anchorIndex = -1;
    private int leadIndex = -1;
    private int firstChangedIndex = Integer.MAX_VALUE;
    private int lastChangedIndex = -1;
    private boolean isAdjusting = false;
    private BitSet value = new BitSet(32);
    private BitSet initialValue = new BitSet(32);
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean leadAnchorNotificationEnabled = true;
    static /* synthetic */ Class class$javax$swing$event$ListSelectionListener;

    OptionListModel() {
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.add(class$javax$swing$event$ListSelectionListener != null ? class$javax$swing$event$ListSelectionListener : (class$javax$swing$event$ListSelectionListener = OptionListModel.class$("javax.swing.event.ListSelectionListener")), listSelectionListener);
    }

    public void addSelectionInterval(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return;
        }
        if (this.getSelectionMode() != 2) {
            this.setSelectionInterval(n, n2);
            return;
        }
        this.updateLeadAnchorIndices(n, n2);
        int n3 = Integer.MAX_VALUE;
        int n4 = -1;
        int n5 = Math.min(n, n2);
        int n6 = Math.max(n, n2);
        this.changeSelection(n3, n4, n5, n6);
    }

    private void changeSelection(int n, int n2, int n3, int n4) {
        this.changeSelection(n, n2, n3, n4, true);
    }

    private void changeSelection(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = Math.min(n3, n);
        while (n5 <= Math.max(n4, n2)) {
            boolean bl2 = this.contains(n, n2, n5);
            boolean bl3 = this.contains(n3, n4, n5);
            if (bl3 && bl2) {
                if (bl) {
                    bl2 = false;
                } else {
                    bl3 = false;
                }
            }
            if (bl3) {
                this.set(n5);
            }
            if (bl2) {
                this.clear(n5);
            }
            ++n5;
        }
        this.fireValueChanged();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void clear(int n) {
        if (!this.value.get(n)) {
            return;
        }
        this.value.clear(n);
        Option option = (Option)this.get(n);
        option.setSelection(false);
        this.markAsDirty(n);
        if (n == this.minIndex) {
            ++this.minIndex;
            while (this.minIndex <= this.maxIndex) {
                if (this.value.get(this.minIndex)) break;
                ++this.minIndex;
            }
        }
        if (n == this.maxIndex) {
            --this.maxIndex;
            while (this.minIndex <= this.maxIndex) {
                if (this.value.get(this.maxIndex)) break;
                --this.maxIndex;
            }
        }
        if (this.isSelectionEmpty()) {
            this.minIndex = Integer.MAX_VALUE;
            this.maxIndex = -1;
        }
    }

    public void clearSelection() {
        this.removeSelectionInterval(this.minIndex, this.maxIndex);
    }

    public Object clone() throws CloneNotSupportedException {
        OptionListModel optionListModel = (OptionListModel)super.clone();
        optionListModel.value = (BitSet)this.value.clone();
        optionListModel.listenerList = new EventListenerList();
        return optionListModel;
    }

    private boolean contains(int n, int n2, int n3) {
        return n3 >= n && n3 <= n2;
    }

    private void fireValueChanged() {
        if (this.lastChangedIndex == -1) {
            return;
        }
        int n = this.firstChangedIndex;
        int n2 = this.lastChangedIndex;
        this.firstChangedIndex = Integer.MAX_VALUE;
        this.lastChangedIndex = -1;
        this.fireValueChanged(n, n2);
    }

    protected void fireValueChanged(int n, int n2) {
        this.fireValueChanged(n, n2, this.getValueIsAdjusting());
    }

    protected void fireValueChanged(int n, int n2, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListSelectionEvent listSelectionEvent = null;
        int n3 = objectArray.length - 2;
        while (n3 >= 0) {
            if (objectArray[n3] == (class$javax$swing$event$ListSelectionListener != null ? class$javax$swing$event$ListSelectionListener : OptionListModel.class$("javax.swing.event.ListSelectionListener"))) {
                if (listSelectionEvent == null) {
                    listSelectionEvent = new ListSelectionEvent(this, n, n2, bl);
                }
                ((ListSelectionListener)objectArray[n3 + 1]).valueChanged(listSelectionEvent);
            }
            n3 -= 2;
        }
    }

    protected void fireValueChanged(boolean bl) {
        this.fireValueChanged(this.getMinSelectionIndex(), this.getMaxSelectionIndex(), bl);
    }

    public int getAnchorSelectionIndex() {
        return this.anchorIndex;
    }

    public BitSet getInitialSelection() {
        return this.initialValue;
    }

    public int getLeadSelectionIndex() {
        return this.leadIndex;
    }

    public int getMaxSelectionIndex() {
        return this.maxIndex;
    }

    public int getMinSelectionIndex() {
        return this.isSelectionEmpty() ? -1 : this.minIndex;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    public void insertIndexInterval(int n, int n2, boolean bl) {
        int n3 = bl ? n : n + 1;
        int n4 = n3 + n2 - 1;
        int n5 = this.maxIndex;
        while (n5 >= n3) {
            this.setState(n5 + n2, this.value.get(n5));
            --n5;
        }
        boolean bl2 = this.value.get(n);
        int n6 = n3;
        while (n6 <= n4) {
            this.setState(n6, bl2);
            ++n6;
        }
    }

    public boolean isLeadAnchorNotificationEnabled() {
        return this.leadAnchorNotificationEnabled;
    }

    public boolean isSelectedIndex(int n) {
        return n < this.minIndex || n > this.maxIndex ? false : this.value.get(n);
    }

    public boolean isSelectionEmpty() {
        return this.minIndex > this.maxIndex;
    }

    private void markAsDirty(int n) {
        this.firstChangedIndex = Math.min(this.firstChangedIndex, n);
        this.lastChangedIndex = Math.max(this.lastChangedIndex, n);
    }

    public void removeIndexInterval(int n, int n2) {
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        int n5 = n4 - n3 + 1;
        int n6 = n3;
        while (n6 <= this.maxIndex) {
            this.setState(n6, this.value.get(n6 + n5));
            ++n6;
        }
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(class$javax$swing$event$ListSelectionListener != null ? class$javax$swing$event$ListSelectionListener : (class$javax$swing$event$ListSelectionListener = OptionListModel.class$("javax.swing.event.ListSelectionListener")), listSelectionListener);
    }

    public void removeSelectionInterval(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return;
        }
        this.updateLeadAnchorIndices(n, n2);
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        int n5 = Integer.MAX_VALUE;
        int n6 = -1;
        this.changeSelection(n3, n4, n5, n6);
    }

    private void set(int n) {
        if (this.value.get(n)) {
            return;
        }
        this.value.set(n);
        Option option = (Option)this.get(n);
        option.setSelection(true);
        this.markAsDirty(n);
        this.minIndex = Math.min(this.minIndex, n);
        this.maxIndex = Math.max(this.maxIndex, n);
    }

    public void setAnchorSelectionIndex(int n) {
        this.anchorIndex = n;
    }

    public void setInitialSelection(int n) {
        if (this.initialValue.get(n)) {
            return;
        }
        if (this.selectionMode == 0) {
            this.initialValue.and(new BitSet());
        }
        this.initialValue.set(n);
    }

    public void setLeadAnchorNotificationEnabled(boolean bl) {
        this.leadAnchorNotificationEnabled = bl;
    }

    public void setLeadSelectionIndex(int n) {
        int n2 = this.anchorIndex;
        if (this.getSelectionMode() == 0) {
            n2 = n;
        }
        int n3 = Math.min(this.anchorIndex, this.leadIndex);
        int n4 = Math.max(this.anchorIndex, this.leadIndex);
        int n5 = Math.min(n2, n);
        int n6 = Math.max(n2, n);
        if (this.value.get(this.anchorIndex)) {
            this.changeSelection(n3, n4, n5, n6);
        } else {
            this.changeSelection(n5, n6, n3, n4, false);
        }
        this.anchorIndex = n2;
        this.leadIndex = n;
    }

    public void setSelectionInterval(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return;
        }
        if (this.getSelectionMode() == 0) {
            n = n2;
        }
        this.updateLeadAnchorIndices(n, n2);
        int n3 = this.minIndex;
        int n4 = this.maxIndex;
        int n5 = Math.min(n, n2);
        int n6 = Math.max(n, n2);
        this.changeSelection(n3, n4, n5, n6);
    }

    public void setSelectionMode(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.selectionMode = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid selectionMode");
            }
        }
    }

    private void setState(int n, boolean bl) {
        if (bl) {
            this.set(n);
        } else {
            this.clear(n);
        }
    }

    public void setValueIsAdjusting(boolean bl) {
        if (bl != this.isAdjusting) {
            this.isAdjusting = bl;
            this.fireValueChanged(bl);
        }
    }

    public String toString() {
        String string = String.valueOf(this.getValueIsAdjusting() ? "~" : "=") + this.value.toString();
        return String.valueOf(this.getClass().getName()) + " " + Integer.toString(this.hashCode()) + " " + string;
    }

    private void updateLeadAnchorIndices(int n, int n2) {
        if (this.leadAnchorNotificationEnabled) {
            if (this.anchorIndex != n) {
                if (this.anchorIndex != -1) {
                    this.markAsDirty(this.anchorIndex);
                }
                this.markAsDirty(n);
            }
            if (this.leadIndex != n2) {
                if (this.leadIndex != -1) {
                    this.markAsDirty(this.leadIndex);
                }
                this.markAsDirty(n2);
            }
        }
        this.anchorIndex = n;
        this.leadIndex = n2;
    }
}

