/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto;

import org.logi.crypto.Crypto;

public abstract class Producer
extends Crypto
implements Runnable {
    private static final boolean DEBUG = false;
    private volatile byte[][] buffers;
    private volatile int consuming;
    private volatile int filling;
    private volatile boolean terminating = false;
    private Thread thread;

    public synchronized void kill() {
        this.terminating = true;
        this.notify();
    }

    protected void start() {
        this.thread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] nextBuffer() {
        int n = (this.consuming + 1) % 4;
        Producer producer = this;
        synchronized (producer) {
            while (true) {
                if (n != this.filling) {
                    this.consuming = n;
                    this.notify();
                    return this.buffers[n];
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block5: while (!this.terminating) {
            this.calculate(this.buffers[this.filling]);
            int n = (this.filling + 1) % 4;
            Producer producer = this;
            synchronized (producer) {
                while (true) {
                    while (true) {
                        if (n != this.consuming || this.terminating) {
                            this.filling = n;
                            this.notify();
                            continue block5;
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public abstract void calculate(byte[] var1);

    protected Producer(int n) {
        this.buffers = new byte[4][n];
        this.consuming = 3;
        this.filling = 0;
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
    }
}

