/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.modes;

import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.modes.EncryptMode;
import org.logi.crypto.modes.OFBProducer;

public class EncryptOFB
extends EncryptMode {
    private OFBProducer producer;
    private int bufSize;
    private byte[] keyStream;
    private int keyPos;
    private boolean wroteIV = false;

    public CipherKey getKey() {
        return this.producer.key;
    }

    public synchronized void setKey(CipherKey cipherKey) {
        if (this.producer != null) {
            this.producer.kill();
        }
        this.wroteIV = false;
        this.producer = new OFBProducer(cipherKey, this.bufSize);
    }

    public int plainBlockSize() {
        return 1;
    }

    public synchronized byte[] flush() {
        return new byte[0];
    }

    public synchronized byte[] encrypt(byte[] byArray, int n, int n2) {
        byte[] byArray2;
        int n3 = 0;
        if (!this.wroteIV) {
            byArray2 = new byte[n2 + this.producer.ibs];
            System.arraycopy(this.producer.IV, 0, byArray2, 0, this.producer.ibs);
            n3 = this.producer.ibs;
            this.wroteIV = true;
        } else {
            byArray2 = new byte[n2];
        }
        if (this.keyStream == null) {
            this.keyStream = this.producer.nextBuffer();
            this.keyPos = 0;
        }
        while (n2 > 0) {
            if (this.keyPos == this.keyStream.length) {
                this.keyStream = this.producer.nextBuffer();
                this.keyPos = 0;
            }
            int n4 = Math.min(n2, this.keyStream.length - this.keyPos);
            n2 -= n4;
            int n5 = n + n4;
            while (n < n5) {
                byArray2[n3++] = (byte)(byArray[n++] ^ this.keyStream[this.keyPos++]);
            }
        }
        return byArray2;
    }

    public void close() {
        if (this.producer == null) {
            return;
        }
        this.producer.kill();
        this.producer = null;
    }

    public EncryptOFB(CipherKey cipherKey, int n) {
        this.bufSize = n;
        this.setKey(cipherKey);
    }

    public EncryptOFB(int n) {
        this.bufSize = n;
    }
}

