/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.logi.crypto.Crypto;
import org.logi.crypto.hash.SHA1State;
import org.logi.crypto.io.SignStream;
import org.logi.crypto.io.VerifyStream;
import org.logi.crypto.keys.KeyPair;
import org.logi.crypto.keys.RSAKey;
import org.logi.crypto.keys.SignatureKey;

public class TestSign
extends Crypto {
    static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Crypto.initRandom();
        System.out.println("Generating RSA Keys");
        KeyPair keyPair = RSAKey.createKeys(512);
        SignatureKey signatureKey = (SignatureKey)keyPair.getPublic();
        SignatureKey signatureKey2 = (SignatureKey)keyPair.getPrivate();
        System.out.println("Please enter or pipe something to standard input");
        PipedInputStream pipedInputStream = new PipedInputStream();
        PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
        new VerifyThread(new VerifyStream(pipedInputStream, 512, signatureKey, new SHA1State())).start();
        SignStream signStream = new SignStream(pipedOutputStream, 512, signatureKey2, new SHA1State());
        TestSign.copyStream(System.in, signStream);
        ((OutputStream)signStream).close();
    }

    private TestSign() {
    }

    static class VerifyThread
    extends Thread {
        InputStream in;

        public void run() {
            try {
                TestSign.copyStream(this.in, System.out);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }

        public VerifyThread(InputStream inputStream) {
            this.in = inputStream;
        }
    }
}

