/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.test;

import java.io.PrintWriter;
import org.logi.crypto.Crypto;
import org.logi.crypto.test.TestKey;
import org.logi.crypto.test.TestMode;

public class TestIterate
extends Crypto {
    private static char[] metricPrefix = new char[]{'a', 'p', 'n', 'm', ' ', 'K', 'M', 'G', 'T'};
    private static int prefixNeutral = 4;
    private static int prefixMax = metricPrefix.length - prefixNeutral - 1;
    static String[] keyTypes = new String[]{"Caesar", "DES", "TriDES", "Blowfish", "RSA", "DH"};
    static String[] modes = new String[]{"ECB", "CBC", "CFB", "OFB"};

    public static String metricString(double d, int n) {
        if (d == 0.0) {
            return "0";
        }
        int n2 = 0;
        while (d > (double)(10 * n) && n2 < prefixMax) {
            d /= (double)n;
            ++n2;
        }
        while (d < (double)(n / 10) && n2 > -prefixNeutral) {
            d *= (double)n;
            --n2;
        }
        String string = String.valueOf((int)(d + 0.5)) + " ";
        if (n2 == 0) {
            return string;
        }
        if (-prefixNeutral < n2 && n2 < prefixMax) {
            return string + metricPrefix[n2 + prefixNeutral];
        }
        return string + "e" + 3 * n2 + " ";
    }

    private static void help() {
        System.err.println("Iterate the tests in TestKey and TestMode over");
        System.err.println("all possible key and mode combinations.");
        System.err.println();
        System.err.println("Use: java org.logi.crypto.test.TestIterate <parameter>*");
        System.err.println("  <parameter> ::= -v|-q|-r n|+K|-K|+M|-M");
        System.err.println();
        System.err.println("Where:");
        System.err.println("  -v     changes to verbose mode.");
        System.err.println("  -q     changes to quiet mode.");
        System.err.println("  -r n   specifies to run n iterations.");
        System.err.println("  +K -K  enable/disable calls to TestKey.");
        System.err.println("  +M -M  enable/disable calls to TestMode.");
        System.err.println();
        System.err.println("By default all tests are enabled and iterated once.");
        System.exit(0);
    }

    public static void main(String[] stringArray) throws Exception {
        Crypto.initRandom();
        PrintWriter printWriter = new PrintWriter(System.out, true);
        PrintWriter printWriter2 = null;
        int n = 1;
        boolean bl = true;
        boolean bl2 = true;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("-v")) {
                printWriter2 = printWriter;
            } else if (stringArray[n2].equals("-q")) {
                printWriter2 = null;
            } else if (stringArray[n2].equals("+K")) {
                bl = true;
            } else if (stringArray[n2].equals("-K")) {
                bl = false;
            } else if (stringArray[n2].equals("+M")) {
                bl2 = true;
            } else if (stringArray[n2].equals("-M")) {
                bl2 = false;
            } else if (stringArray[n2].equals("-r")) {
                if (n2 + 1 == stringArray.length) {
                    System.err.println("Missing value following -r");
                    TestIterate.help();
                }
                try {
                    n = Integer.parseInt(stringArray[++n2]);
                }
                catch (Exception exception) {
                    TestIterate.help();
                }
            } else {
                TestIterate.help();
            }
            ++n2;
        }
        n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            System.out.println();
            System.out.println("=====================================================");
            System.out.print("== STARTING ROUND " + (n3 + 1) + "/" + n + " OF TESTING, ");
            if (n2 != 0) {
                System.out.print("NO ");
            }
            System.out.println("ERRORS FOUND");
            System.out.println("=====================================================");
            System.out.println();
            if (bl) {
                n4 = 0;
                while (n4 < keyTypes.length) {
                    n2 &= TestKey.test(keyTypes[n4], printWriter2, printWriter);
                    ++n4;
                }
            }
            if (bl2) {
                n4 = 0;
                while (n4 < keyTypes.length) {
                    int n5 = 0;
                    while (n5 < modes.length) {
                        n2 &= TestMode.test(keyTypes[n4], modes[n5], printWriter2, printWriter);
                        ++n5;
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        if (n2 != 0) {
            printWriter.println();
            printWriter.println("All tests passed");
        } else {
            printWriter.println();
            printWriter.println("Some tests failed\u0007\u0007\u0007");
        }
        System.exit(n2 != 0 ? 0 : 1);
    }

    private TestIterate() {
    }
}

