/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.AudioFileWriter;
import javax.sound.sampled.spi.FormatConversionProvider;
import javax.sound.sampled.spi.MixerProvider;

public class AudioSystem {
    public static final int NOT_SPECIFIED = -1;
    private static final String defaultServicesClassName = "com.sun.media.sound.DefaultServices";
    private static final String jdk13ServicesClassName = "com.sun.media.sound.JDK13Services";
    private static final String servicesMethodName = "getProviders";
    private static final Class[] servicesParamTypes = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = AudioSystem.class$("java.lang.String"))};
    static /* synthetic */ Class class$java$lang$String;

    private AudioSystem() {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] providers = AudioSystem.getAudioFileReaders();
        AudioFileFormat format = null;
        int i = 0;
        while (i < providers.length) {
            try {
                format = providers[i].getAudioFileFormat(file);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                ++i;
            }
        }
        if (format == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return format;
    }

    public static AudioFileFormat getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] providers = AudioSystem.getAudioFileReaders();
        AudioFileFormat format = null;
        int i = 0;
        while (i < providers.length) {
            try {
                format = providers[i].getAudioFileFormat(stream);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                ++i;
            }
        }
        if (format == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return format;
    }

    public static AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] providers = AudioSystem.getAudioFileReaders();
        AudioFileFormat format = null;
        int i = 0;
        while (i < providers.length) {
            try {
                format = providers[i].getAudioFileFormat(url);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                ++i;
            }
        }
        if (format == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return format;
    }

    private static AudioFileReader[] getAudioFileReaders() {
        Vector v = new Vector();
        try {
            Class.forName("sun.misc.Service");
            v = AudioSystem.getJDK13Services("javax.sound.sampled.spi.AudioFileReader");
        }
        catch (Exception exception) {
            v = AudioSystem.getDefaultServices("javax.sound.sampled.spi.AudioFileReader");
        }
        AudioFileReader[] varray = new AudioFileReader[v.size()];
        int i = 0;
        while (i < varray.length) {
            varray[i] = (AudioFileReader)v.elementAt(i);
            ++i;
        }
        return varray;
    }

    public static AudioFileFormat.Type[] getAudioFileTypes() {
        AudioFileWriter[] providers = AudioSystem.getAudioFileWriters();
        AudioFileFormat.Type[][] fileTypes = new AudioFileFormat.Type[providers.length][];
        AudioFileFormat.Type[] returnTypes = null;
        int numTypes = 0;
        int index = 0;
        int i = 0;
        while (i < providers.length) {
            fileTypes[i] = providers[i].getAudioFileTypes();
            numTypes += fileTypes[i].length;
            ++i;
        }
        returnTypes = new AudioFileFormat.Type[numTypes];
        int i2 = 0;
        while (i2 < providers.length) {
            int j = 0;
            while (j < fileTypes[i2].length) {
                returnTypes[index] = fileTypes[i2][j];
                ++index;
                ++j;
            }
            ++i2;
        }
        return returnTypes;
    }

    public static AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream stream) {
        AudioFileWriter[] providers = AudioSystem.getAudioFileWriters();
        AudioFileFormat.Type[][] fileTypes = new AudioFileFormat.Type[providers.length][];
        AudioFileFormat.Type[] returnTypes = null;
        int numTypes = 0;
        int index = 0;
        int i = 0;
        while (i < providers.length) {
            fileTypes[i] = providers[i].getAudioFileTypes(stream);
            numTypes += fileTypes[i].length;
            ++i;
        }
        returnTypes = new AudioFileFormat.Type[numTypes];
        int i2 = 0;
        while (i2 < providers.length) {
            int j = 0;
            while (j < fileTypes[i2].length) {
                returnTypes[index] = fileTypes[i2][j];
                ++index;
                ++j;
            }
            ++i2;
        }
        return returnTypes;
    }

    private static AudioFileWriter[] getAudioFileWriters() {
        Vector v = new Vector();
        try {
            Class.forName("sun.misc.Service");
            v = AudioSystem.getJDK13Services("javax.sound.sampled.spi.AudioFileWriter");
        }
        catch (Exception exception) {
            v = AudioSystem.getDefaultServices("javax.sound.sampled.spi.AudioFileWriter");
        }
        AudioFileWriter[] varray = new AudioFileWriter[v.size()];
        int i = 0;
        while (i < varray.length) {
            varray[i] = (AudioFileWriter)v.elementAt(i);
            ++i;
        }
        return varray;
    }

    public static AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] providers = AudioSystem.getAudioFileReaders();
        AudioInputStream audioStream = null;
        int i = 0;
        while (i < providers.length) {
            try {
                audioStream = providers[i].getAudioInputStream(file);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                ++i;
            }
        }
        if (audioStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input stream");
        }
        return audioStream;
    }

    public static AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] providers = AudioSystem.getAudioFileReaders();
        AudioInputStream audioStream = null;
        int i = 0;
        while (i < providers.length) {
            try {
                audioStream = providers[i].getAudioInputStream(stream);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                ++i;
            }
        }
        if (audioStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input stream");
        }
        return audioStream;
    }

    public static AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] providers = AudioSystem.getAudioFileReaders();
        AudioInputStream audioStream = null;
        int i = 0;
        while (i < providers.length) {
            try {
                audioStream = providers[i].getAudioInputStream(url);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                ++i;
            }
        }
        if (audioStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input stream");
        }
        return audioStream;
    }

    public static AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        FormatConversionProvider[] codecs = AudioSystem.getFormatConversionProviders();
        int i = 0;
        while (i < codecs.length) {
            if (codecs[i].isConversionSupported(targetEncoding, sourceStream.getFormat())) {
                return codecs[i].getAudioInputStream(targetEncoding, sourceStream);
            }
            ++i;
        }
        throw new IllegalArgumentException("Unsupported conversion: " + targetEncoding + " from " + sourceStream.getFormat());
    }

    public static AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        if (sourceStream.getFormat().matches(targetFormat)) {
            return sourceStream;
        }
        FormatConversionProvider[] codecs = AudioSystem.getFormatConversionProviders();
        int i = 0;
        while (i < codecs.length) {
            if (codecs[i].isConversionSupported(targetFormat, sourceStream.getFormat())) {
                return codecs[i].getAudioInputStream(targetFormat, sourceStream);
            }
            ++i;
        }
        throw new IllegalArgumentException("Unsupported conversion: " + targetFormat + " from " + sourceStream.getFormat());
    }

    private static Vector getDefaultServices(String serviceName) {
        Vector v = null;
        try {
            Class<?> defaultServices = Class.forName(defaultServicesClassName);
            Method m = defaultServices.getMethod(servicesMethodName, servicesParamTypes);
            Object[] arguments = new Object[]{serviceName};
            v = (Vector)m.invoke(defaultServices, arguments);
        }
        catch (InvocationTargetException invocationTargetException) {
            v = new Vector();
        }
        catch (ClassNotFoundException classNotFoundException) {
            v = new Vector();
        }
        catch (IllegalAccessException illegalAccessException) {
            v = new Vector();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            v = new Vector();
        }
        return v;
    }

    private static FormatConversionProvider[] getFormatConversionProviders() {
        Vector v = new Vector();
        try {
            Class.forName("sun.misc.Service");
            v = AudioSystem.getJDK13Services("javax.sound.sampled.spi.FormatConversionProvider");
        }
        catch (Exception exception) {
            v = AudioSystem.getDefaultServices("javax.sound.sampled.spi.FormatConversionProvider");
        }
        FormatConversionProvider[] varray = new FormatConversionProvider[v.size()];
        int i = 0;
        while (i < varray.length) {
            varray[i] = (FormatConversionProvider)v.elementAt(i);
            ++i;
        }
        return varray;
    }

    private static Vector getJDK13Services(String serviceName) {
        Vector v = null;
        try {
            Class<?> jdk13Services = Class.forName(jdk13ServicesClassName);
            Method m = jdk13Services.getMethod(servicesMethodName, servicesParamTypes);
            Object[] arguments = new Object[]{serviceName};
            v = (Vector)m.invoke(jdk13Services, arguments);
        }
        catch (InvocationTargetException invocationTargetException) {
            v = new Vector();
        }
        catch (ClassNotFoundException classNotFoundException) {
            v = new Vector();
        }
        catch (IllegalAccessException illegalAccessException) {
            v = new Vector();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            v = new Vector();
        }
        return v;
    }

    public static Line getLine(Line.Info info) throws LineUnavailableException {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        LineUnavailableException lue = null;
        int i = 0;
        while (i < infoArray.length) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            if (mixer.isLineSupported(info)) {
                try {
                    return mixer.getLine(info);
                }
                catch (LineUnavailableException e) {
                    lue = e;
                }
            }
            ++i;
        }
        if (lue != null) {
            throw lue;
        }
        throw new IllegalArgumentException("No line matching " + info.toString() + " is supported.");
    }

    public static Mixer getMixer(Mixer.Info info) {
        Object mixer = null;
        Vector providers = AudioSystem.getMixerProviders();
        int i = 0;
        while (i < providers.size()) {
            try {
                return ((MixerProvider)providers.elementAt(i)).getMixer(info);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NullPointerException nullPointerException) {}
            ++i;
        }
        throw new IllegalArgumentException("Mixer not supported: " + info.toString());
    }

    public static Mixer.Info[] getMixerInfo() {
        Vector providers = AudioSystem.getMixerProviders();
        Vector<Mixer.Info> infos = new Vector<Mixer.Info>();
        int i = 0;
        while (i < providers.size()) {
            Mixer.Info[] someInfos = ((MixerProvider)providers.elementAt(i)).getMixerInfo();
            int j = 0;
            while (j < someInfos.length) {
                infos.addElement(someInfos[j]);
                ++j;
            }
            ++i;
        }
        Mixer.Info[] allInfos = new Mixer.Info[infos.size()];
        i = 0;
        while (i < allInfos.length) {
            allInfos[i] = (Mixer.Info)infos.elementAt(i);
            ++i;
        }
        return allInfos;
    }

    private static Vector getMixerProviders() {
        Vector providers = null;
        try {
            Class.forName("sun.misc.Service");
            providers = AudioSystem.getJDK13Services("javax.sound.sampled.spi.MixerProvider");
        }
        catch (Exception exception) {
            providers = AudioSystem.getDefaultServices("javax.sound.sampled.spi.MixerProvider");
        }
        return providers;
    }

    public static Line.Info[] getSourceLineInfo(Line.Info info) {
        Vector<Line.Info> vector = new Vector<Line.Info>();
        Object fullInfo = null;
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < infoArray.length) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            Line.Info[] currentInfoArray = mixer.getSourceLineInfo(info);
            int j = 0;
            while (j < currentInfoArray.length) {
                vector.addElement(currentInfoArray[j]);
                ++j;
            }
            ++i;
        }
        Line.Info[] returnedArray = new Line.Info[vector.size()];
        int i2 = 0;
        while (i2 < returnedArray.length) {
            returnedArray[i2] = (Line.Info)vector.elementAt(i2);
            ++i2;
        }
        return returnedArray;
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat.Encoding sourceEncoding) {
        FormatConversionProvider[] codecs = AudioSystem.getFormatConversionProviders();
        Vector<AudioFormat.Encoding[]> encodings = new Vector<AudioFormat.Encoding[]>();
        int size = 0;
        int index = 0;
        AudioFormat.Encoding[] encs = null;
        int i = 0;
        while (i < codecs.length) {
            if (codecs[i].isSourceEncodingSupported(sourceEncoding)) {
                encs = codecs[i].getTargetEncodings();
                size += encs.length;
                encodings.addElement(encs);
            }
            ++i;
        }
        AudioFormat.Encoding[] encs2 = new AudioFormat.Encoding[size];
        int i2 = 0;
        while (i2 < encodings.size()) {
            encs = (AudioFormat.Encoding[])encodings.elementAt(i2);
            int j = 0;
            while (j < encs.length) {
                encs2[index++] = encs[j];
                ++j;
            }
            ++i2;
        }
        return encs2;
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        FormatConversionProvider[] codecs = AudioSystem.getFormatConversionProviders();
        Vector<AudioFormat.Encoding[]> encodings = new Vector<AudioFormat.Encoding[]>();
        int size = 0;
        int index = 0;
        AudioFormat.Encoding[] encs = null;
        int i = 0;
        while (i < codecs.length) {
            encs = codecs[i].getTargetEncodings(sourceFormat);
            size += encs.length;
            encodings.addElement(encs);
            ++i;
        }
        AudioFormat.Encoding[] encs2 = new AudioFormat.Encoding[size];
        int i2 = 0;
        while (i2 < encodings.size()) {
            encs = (AudioFormat.Encoding[])encodings.elementAt(i2);
            int j = 0;
            while (j < encs.length) {
                encs2[index++] = encs[j];
                ++j;
            }
            ++i2;
        }
        return encs2;
    }

    public static AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        FormatConversionProvider[] codecs = AudioSystem.getFormatConversionProviders();
        Vector<AudioFormat[]> formats = new Vector<AudioFormat[]>();
        int size = 0;
        int index = 0;
        AudioFormat[] fmts = null;
        int i = 0;
        while (i < codecs.length) {
            fmts = codecs[i].getTargetFormats(targetEncoding, sourceFormat);
            size += fmts.length;
            formats.addElement(fmts);
            ++i;
        }
        AudioFormat[] fmts2 = new AudioFormat[size];
        int i2 = 0;
        while (i2 < formats.size()) {
            fmts = (AudioFormat[])formats.elementAt(i2);
            int j = 0;
            while (j < fmts.length) {
                fmts2[index++] = fmts[j];
                ++j;
            }
            ++i2;
        }
        return fmts2;
    }

    public static Line.Info[] getTargetLineInfo(Line.Info info) {
        Vector<Line.Info> vector = new Vector<Line.Info>();
        Object fullInfo = null;
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < infoArray.length) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            Line.Info[] currentInfoArray = mixer.getTargetLineInfo(info);
            int j = 0;
            while (j < currentInfoArray.length) {
                vector.addElement(currentInfoArray[j]);
                ++j;
            }
            ++i;
        }
        Line.Info[] returnedArray = new Line.Info[vector.size()];
        int i2 = 0;
        while (i2 < returnedArray.length) {
            returnedArray[i2] = (Line.Info)vector.elementAt(i2);
            ++i2;
        }
        return returnedArray;
    }

    public static boolean isConversionSupported(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        FormatConversionProvider[] codecs = AudioSystem.getFormatConversionProviders();
        int i = 0;
        while (i < codecs.length) {
            if (codecs[i].isConversionSupported(targetEncoding, sourceFormat)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isConversionSupported(AudioFormat targetFormat, AudioFormat sourceFormat) {
        FormatConversionProvider[] codecs = AudioSystem.getFormatConversionProviders();
        int i = 0;
        while (i < codecs.length) {
            if (codecs[i].isConversionSupported(targetFormat, sourceFormat)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type fileType) {
        AudioFileWriter[] providers = AudioSystem.getAudioFileWriters();
        boolean isSupported = false;
        int i = 0;
        while (i < providers.length) {
            isSupported = providers[i].isFileTypeSupported(fileType);
            if (isSupported) {
                return isSupported;
            }
            ++i;
        }
        return isSupported;
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type fileType, AudioInputStream stream) {
        AudioFileWriter[] providers = AudioSystem.getAudioFileWriters();
        boolean isSupported = false;
        int i = 0;
        while (i < providers.length) {
            isSupported = providers[i].isFileTypeSupported(fileType, stream);
            if (isSupported) {
                return isSupported;
            }
            ++i;
        }
        return isSupported;
    }

    public static boolean isLineSupported(Line.Info info) {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < infoArray.length) {
            Mixer mixer;
            if (infoArray[i] != null && (mixer = AudioSystem.getMixer(infoArray[i])).isLineSupported(info)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int write(AudioInputStream stream, AudioFileFormat.Type fileType, File out) throws IOException {
        AudioFileWriter[] providers = AudioSystem.getAudioFileWriters();
        int bytesWritten = 0;
        boolean flag = false;
        int i = 0;
        while (i < providers.length) {
            try {
                bytesWritten = providers[i].write(stream, fileType, out);
                flag = true;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ++i;
            }
        }
        if (!flag) {
            throw new IllegalArgumentException("could not write audio file: file type not supported: " + fileType);
        }
        return bytesWritten;
    }

    public static int write(AudioInputStream stream, AudioFileFormat.Type fileType, OutputStream out) throws IOException {
        AudioFileWriter[] providers = AudioSystem.getAudioFileWriters();
        int bytesWritten = 0;
        boolean flag = false;
        int i = 0;
        while (i < providers.length) {
            try {
                bytesWritten = providers[i].write(stream, fileType, out);
                flag = true;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ++i;
            }
        }
        if (!flag) {
            throw new IllegalArgumentException("could not write audio file: file type not supported: " + fileType);
        }
        return bytesWritten;
    }
}

