/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.Control;

public abstract class EnumControl
extends Control {
    private Object[] values;
    private Object value;

    protected EnumControl(Type type, Object[] values, Object value) {
        super(type);
        this.values = values;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public Object[] getValues() {
        Object[] localArray = new Object[this.values.length];
        int i = 0;
        while (i < this.values.length) {
            localArray[i] = this.values[i];
            ++i;
        }
        return localArray;
    }

    private boolean isValueSupported(Object value) {
        int i = 0;
        while (i < this.values.length) {
            if (this.values.equals(this.values[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setValue(Object value) {
        if (!this.isValueSupported(value)) {
            throw new IllegalArgumentException("Requested value " + value + " is not supported.");
        }
        this.value = value;
    }

    public String toString() {
        return new String(String.valueOf(String.valueOf(this.getType())) + " with current value: " + this.getValue());
    }

    public static class Type
    extends Control.Type {
        public static final Type REVERB = new Type("Reverb");

        protected Type(String name) {
            super(name);
        }
    }
}

