package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.Endpoint;

/** 
 * An endpoint with a fast isPrivate method.  (It must be fast
 * for the rendering to be fast.)  Also, includes a special value
 * for representing no location.  (So from a set-theoretic point of
 * of view, it shouldn't really be a subclass of Endpoint.)
 */
class CachingEndpoint extends Endpoint {
    private boolean isPrivate;
    private boolean isNormal;
    private boolean isReplyToMcast;
    
    /** These are only defined if isNormal. */
    private ResultPanelModel model;
    private TableLine line;

    /** Creates a normal endpoint. */
    public CachingEndpoint(String host, int port, boolean replyToMcast) {
        super(host, port);
        this.isPrivate=super.isPrivateAddress();
        this.isNormal=true;
        this.isReplyToMcast = replyToMcast;
    }
    /** Creates an endpoint representing multiple values
     *  model and line are used to print the number of
     *  of results this represents. */
    public CachingEndpoint(ResultPanelModel model, TableLine line) {
        super("",1);
        this.isPrivate=false;
        this.isNormal=false;
        this.isReplyToMcast = false;
        this.model=model;
        this.line=line;
    }
    public boolean isPrivateAddress() {
        return this.isPrivate && !isReplyToMcast;
    }
    public boolean isNormal() {
        return this.isNormal;
    }
    
    /** Returns the number of locations this represents.  If !isNormal(),
     *  always returns 1. */
    public int numLocations() {
        if (model==null || line==null)
            return 1;
        return model.getChildCount(line);
    }
}
    
