package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.settings.*;
import javax.swing.*;
import javax.swing.table.*;
import java.awt.*;

/** Draws CachingEndpoints's appropriately colorized */
class CachingEndpointRenderer extends DefaultTableCellRenderer {

	private static final Color NON_PRIVATE_COLOR = 
		ThemeFileHandler.WINDOW8_COLOR.getValue();

	private static final Color PRIVATE_COLOR = 
		ThemeFileHandler.SEARCH_PRIVATE_IP_COLOR.getValue();


    public Component getTableCellRendererComponent(JTable table,
                                                   Object value, 
                                                   boolean isSel, 
                                                   boolean hasFocus,
                                                   int row,
                                                   int column) {        
        //Note that we don't display all the information in the column.
        CachingEndpoint e=(CachingEndpoint)value;
        String tag;
        if (e.isNormal())
            tag=e.getHostname();
        else 
            tag="Multiple ("+e.numLocations()+")";
        Component ret=super.getTableCellRendererComponent(
            table, tag, isSel, hasFocus, row, column);                                                        
        //Render private IP addresses in red, others in black.  The second call
        //is necessary to prevent everything from turning red, since one
        //renderer is shared among all cells.
        if (e.isPrivateAddress())
            ret.setForeground(PRIVATE_COLOR);
        else
            ret.setForeground(NON_PRIVATE_COLOR);
        return ret;
    }
}
