package com.limegroup.gnutella.gui.search;

import javax.swing.*;
import java.awt.*;

/** Simple extension of JPanel that makes a FlowLayout.LEADING JPanel that
 *  has a background image which is painted.
 */
public class DitherScrollPane extends JScrollPane {
    
	private final Ditherer DITHERER;

    /**
	 * Creates a new <tt>DitherScrollPane</tt> with the specified 
	 * <tt>Ditherer</tt>.
	 * 
     * @param ditherer the <tt>Ditherer</tt> that paints the dithered 
	 *  background
     */
    public DitherScrollPane(Component toScroll, Ditherer ditherer) {
        super(toScroll);
		DITHERER = ditherer;
    }
    

    /** Does the actual placement of the background image.
     */
    public void paintComponent(java.awt.Graphics g) {
        super.paintComponent(g);   //TODO: needed?
        DITHERER.draw(g, getSize().height, getSize().width);
    }
}



