package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GUIUtils;

/**
 * The speed displayed in a search result line.  Contains a string description,
 * the numerical speed (for accurate sorting purposes), and whether the speed is
 * measured or set by user.  These values are rendered by ResultSpeedRenderer.  
 */
class ResultSpeed {
    private int speed;   
    /** Note that this is calculated once upon construction so rendering is
     *  efficient--a classic time-space tradeoff! */
    private String description;
    private boolean isMeasured;

    public ResultSpeed(int speed, boolean isMeasured) {
        this.speed=speed;
        this.isMeasured=isMeasured;
        this.description=GUIUtils.speed2name(speed);
    }

    /** Returns the actual speed of this, in kb/s. */
    public int intValue() {
        return speed;
    }

    /** A textual description of this speed, e.g., 'Modem'. */
    public String stringValue() {
        return description;
    }

    /** Returns truee iff this speed was measured, not set by the user.
     *  (That is, true iff the measured speed bit was set in the query reply. */
    public boolean isMeasured() {
        return isMeasured;
    }

    /** Returns -1 if this is slower than other, +1 if this is faster than
     *  other, or 0 if they're equal.  The definition of "slower" and "faster"
     *  may or may not take the isMeasured property into account. */
    public int compareTo(Object other) {
        //We currently do NOT look at isMeasured property.
        return this.speed-((ResultSpeed)other).speed;
    }

    /** Returns the faster of a and b, as defined by compareTo. */
    public static ResultSpeed max(ResultSpeed a, ResultSpeed b) {
        return a.compareTo(b)<=0 ? b : a;
    }
    
    /** Same as stringValue(). */
    public String toString() {
        return stringValue();
    }

    /*
    public static void main(String args[]) {
        //These unit tests don't work right because GUIUtils.speed2name
        //forces the GUI to initialize!
        ResultSpeed a=new ResultSpeed(100, true);
        ResultSpeed b=new ResultSpeed(101, false);
        Assert.that(a.compareTo(a)==0);
        Assert.that(b.compareTo(b)==0);
        Assert.that(a.compareTo(b)<0);
        Assert.that(b.compareTo(a)>0);
        Assert.that(ResultSpeed.max(a,b)==b);
        Assert.that(ResultSpeed.max(b,a)==b);
    }
    */
}    
