package com.limegroup.gnutella.gui.tables;

import javax.swing.event.*;
import javax.swing.*;

/**
 * This class listens for selections of rows in the component.
 */
final class SelectionListener implements ListSelectionListener {

    private AbstractTableMediator atm;
    
    SelectionListener(AbstractTableMediator atm) {
        this.atm = atm;
    }

	/**
	 * Implements the <tt>ListSelectionListener</tt> interface, setting
	 * the states of buttons, menus, and anything else depending on the
	 * characteristics of the currently selected row.
	 *
	 * @param e the event producing the selection change
	 */
	public void valueChanged(ListSelectionEvent e) {
        //Ignore extra messages.
        if (e.getValueIsAdjusting()) return;
        
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        // send the message to the component mediator
        // this listener is associated with
        if (lsm.isSelectionEmpty()) {
			atm.handleNoSelection();
        } else {
            int sel = lsm.getMinSelectionIndex();
            if( sel < atm.getSize() ) 
                atm.handleSelection(sel);
            // otherwise it's a java bug for letting us select something
            // that doesn't exist.
        }
    }

}
