/****************************************************************************
**
** $Id: FileListViewItem.cpp,v 1.3 2004/03/05 00:18:33 hemer Exp $
**
** Copyright (C) 2001-2004 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Frank Hemer <frank@hemer.org>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Tom Mishima <tmishima@mail.at-m.or.jp>
**    Joerg Preiss <auba@auba.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "config.h"

#include "globals.h"
#include "FileListViewItem.h"

FileListViewItem::FileListViewItem(QListView *parent,bool isDir /* = FALSE*/)
  : QListViewItem( parent),
    m_pDateTime(NULL),
    m_pModifiedDateTime(NULL),
    m_isDir(isDir),
    m_dateRow(-1),
    m_modDateRow(-1) {
}

FileListViewItem::FileListViewItem ( QListView * parent,
				     QString label1,
				     QString label2,
				     QString label3,
				     QString label4,
				     QString label5,
				     QString label6,
				     QString label7,
				     QString label8 )
  : QListViewItem( parent, label1, label2, label3, label4, label5, label6, label7, label8),
    m_pDateTime(NULL),
    m_pModifiedDateTime(NULL),
    m_isDir(FALSE),
    m_dateRow(-1),
    m_modDateRow(-1) {
}    

FileListViewItem::~FileListViewItem() {
  if (m_pDateTime) delete m_pDateTime;
  if (m_pModifiedDateTime) delete m_pModifiedDateTime;
}

FileListViewItem * FileListViewItem::nextSibling() const {
  return static_cast<FileListViewItem*>(QListViewItem::nextSibling());
}

void FileListViewItem::setDate(int row, const QDateTime * dateTime, const QString txt /* = ""*/) {
  if (m_pDateTime) *m_pDateTime = *dateTime;
  else m_pDateTime = new QDateTime(*dateTime);
  m_dateRow = row;
  setText(row,txt);
}

void FileListViewItem::setModifiedDate(int row, const QDateTime * dateTime, const QString txt /* = ""*/) {
  if (m_pModifiedDateTime) *m_pModifiedDateTime = *dateTime;
  else m_pModifiedDateTime = new QDateTime(*dateTime);
  m_modDateRow = row;
  setText(row,txt);
}

int FileListViewItem::compare ( QListViewItem * i, int col, bool) const {

  FileListViewItem * item = static_cast<FileListViewItem *>(i);
  if (col == 0) {
    return QString::localeAwareCompare(text(0).upper(),item->text(0).upper());
  } else if ( (col == m_dateRow) && m_pDateTime && item->m_pDateTime) {
    return dateCompare(m_pDateTime,item->m_pDateTime);
  } else if ( (col == m_modDateRow) && m_pModifiedDateTime && item->m_pModifiedDateTime) {
    return dateCompare(m_pModifiedDateTime,item->m_pModifiedDateTime);
  } else {
    return QString::localeAwareCompare(text(col),item->text(col));
  }
}

int FileListViewItem::dateCompare(QDateTime * dt1, QDateTime * dt2) const {
  if ((*dt1)<(*dt2)) return -1;
  else if ((*dt1)>(*dt2)) return 1;
  else return 0;
}

