/****************************************************************************
**
** $Id: aboutdialogimpl.cpp,v 1.15 2004/05/05 19:34:09 riemer Exp $
**
** Copyright (C) 2001-2004 Tilo Riemer <riemer@lincvs.org> and
**                         Jose Hernandez <joseh@tesco.net>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/


#include "config.h"
#include "cvsconfig.h"


#ifndef Q_WS_WIN
#include <unistd.h>
#endif


#include <qlabel.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qtextbrowser.h>

#include "globals.h"             // for declaration of 'browser' 
#include "aboutdialogimpl.h"
#include "pixmapcache.h"


/**
 * Constructs a AboutDialogImpl which is a child of 'parent', with the 
 * name 'About Dialog'.
 *
 * The dialog will be 'modal'.
 */

AboutDialogImpl::AboutDialogImpl (QWidget* parent,  const char* version)
	: AboutDialog(parent, "About Dialog", true,
		Qt::WStyle_SysMenu | Qt::WStyle_MinMax | 
		Qt::WStyle_DialogBorder | Qt::WType_Dialog)
{
   setIcon(findEmbeddedPixmap(bUseSmallIcons ? "lincvs-16" : "lincvs-32"));
   VersionString->setText(version);
   setAboutText();   
   setDeveloperText();
   setTranslatorText();
   setAckText();
   setLicenseText();
}


/**
 * Destroys the object and frees any allocated resources
 */

AboutDialogImpl::~AboutDialogImpl()
{
    // no need to delete child widgets, Qt does it all for us
}


// Open browser slot.
void AboutDialogImpl::openBrowser()
{
  runExternal("\"" + ExtApps::g_remoteBrowser.path +"\" "
              + ExtApps::g_remoteBrowser.options + " "
              + tr("http://www.creaphys.de"));
}


// Open browser slot.
void AboutDialogImpl::openBrowserSunSite()
{
  runExternal("\"" + ExtApps::g_remoteBrowser.path +"\" "
              + ExtApps::g_remoteBrowser.options + " "
              + tr("http://www.sunsite.dk"));
}


// Open browser slot.
void AboutDialogImpl::openBrowserVisoel()
{
  runExternal("\"" + ExtApps::g_remoteBrowser.path +"\" "
              + ExtApps::g_remoteBrowser.options + " "
              + tr("http://www.visoel.de"));
}


// Open browser slot.
void AboutDialogImpl::openBrowserBgu()
{
  runExternal("\"" + ExtApps::g_remoteBrowser.path +"\" "
              + ExtApps::g_remoteBrowser.options + " "
              + tr("http://www.bgu-dresden.de"));
}


void AboutDialogImpl::setAboutText()
{
   QString text = "<html><br><br><br><br><p align=\"center\">";
   text += tr("LinCVS - An user friendly CVS frontend");
   text += "<br><br>";
   QString copyright = tr("Copyright (C) 1999 - %1 Tilo Riemer, Frank Hemer and others");
   text += copyright.arg(2004);
   text += "<br>";
   text += tr("All rights reserved.");
   text += "<br><br>";
   text += tr("Homepage: <u><font color=\"#5500ff\">http://www.lincvs.org</font></u>");
   text += "<br><br>";
   text += tr("Please send bug reports to <u><font color=\"#5500ff\">bugs@lincvs.org</font></u>.");
   text += "</p></html>";

   m_pAboutText->setText(text);
}

void AboutDialogImpl::setDeveloperText()
{
   QString text = "<html><h3>";
   text += tr("Active Contributors");
   text += "</h3>";

   text += "<p>";
   text += tr("Frank Hemer &lt;<u><font color=\"#5500ff\">frank at hemer dot org</font></u>&gt;");
   text += "<br>";
   text += tr("Core developer");
   text += "</p>";
   
   text += "<p>";
   text += tr("Tilo Riemer &lt;<u><font color=\"#5500ff\">riemer at lincvs dot org</font></u>&gt;");
   text += "<br>";
   text += tr("Core developer and maintainer");
   text += "</p>";

   text += "<p>";
   text += tr("Sven Trogisch &lt;<u><font color=\"#5500ff\">trogisch at iapp dot de</font></u>&gt;");
   text += "<br>";
   text += tr("Webmaster");
   text += "</p>";

   text += "<br><h3>";
   text += tr("Former Contributors");
   text += "</h3>";

   text += "<p>";
   text += tr("Falk Brettschneider &lt;<u><font color=\"#5500ff\">gigafalk at yahoo dot com</font></u>&gt;");
   text += "<br>";
   text += tr("Developer");
   text += "</p>";

   text += "<p>";
   text += tr("Wim Delvaux &lt;<u><font color=\"#5500ff\">wim dot delvaux at chello dot be</font></u>&gt;");
   text += "<br>";
   text += tr("Core developer");
   text += "</p>";

   text += "<p>";
   text += tr("Jose Hernandez &lt;<u><font color=\"#5500ff\">joseh at tesco dot net</font></u>&gt;");
   text += "<br>";
   text += tr("Core developer");
   text += "</p>";

   text += "<p>";
   text += tr("Helmut Koll &lt;<u><font color=\"#5500ff\">HelmutKoll at web dot de</font></u>&gt;");
   text += "<br>";
   text += tr("Core developer");
   text += "</p>";

   text += "<p>";
   text += tr("Tom Mishima &lt;<u><font color=\"#5500ff\">tmishima at mail dot at-m dot or dot jp</font></u>&gt;");
   text += "<br>";
   text += tr("Core developer");
   text += "</p>";

   text += "<p>";
   text += tr("Jrg Preiss &lt;<u><font color=\"#5500ff\">auba at auba dot de</font></u>&gt;");
   text += "<br>";
   text += tr("Developer");
   text += "</p>";
   
   text += "</html>";

   m_pDeveloperText->setText(text);
}

void AboutDialogImpl::setTranslatorText()
{
   QString text = "<html>";

   text += "<h3>";
   text += tr("Catalan");
   text += "</h3>";

   text += "<p>";
   text += tr("Alan Ward &lt;<u><font color=\"#5500ff\">award at andorra dot ad</font></u>&gt;");
   text += "<br>";

   text += "<h3>";
   text += tr("French");
   text += "</h3>";

   text += "<p>";
   text += tr("Alan Ward &lt;<u><font color=\"#5500ff\">award at andorra dot ad</font></u>&gt;");
   text += "<br>";

   text += "<h3>";
   text += tr("German");
   text += "</h3>";

   text += "<p>";
   text += tr("Stefan Bongartz &lt;<u><font color=\"#5500ff\">mail at stefanbongartz dot de</font></u>&gt;");
   text += "<br>";
   text += tr("Bernhard Walle &lt;<u><font color=\"#5500ff\">bernhard at bwalle dot de</font></u>&gt;");
   text += "</p>";

   text += "<h3>";
   text += tr("Italian");
   text += "</h3>";

   text += "<p>";
   text += tr("Angelo Contardi &lt;<u><font color=\"#5500ff\">angelo dot contardi at italtel dot it</font></u>&gt;");
   text += "</p>";

   text += "<h3>";
   text += tr("Japanese");
   text += "</h3>";

   text += "<p>";
   text += tr("Tom Mishima &lt;<u><font color=\"#5500ff\">tmishima at mail dot at-m dot or dot jp</font></u>&gt;");
   text += "</p>";

   text += "<h3>";
   text += tr("Russian");
   text += "</h3>";

   text += "<p>";
   text += tr("Grigory Bakunov &lt;<u><font color=\"#5500ff\">black at asplinux dot ru</font></u>&gt;");
   text += "<br>";
   text += tr("Konstantin Grusha &lt;<u><font color=\"#5500ff\">zoi at otaku dot ru</font></u>&gt;");
   text += "<br>";
   text += tr("jcukeng from uinc.ru &lt;<u><font color=\"#5500ff\">jcukeng at gmx dot net</font></u>&gt;");
   text += "</p>";

   text += "</html>";

   m_pTranslatorText->setText(text);
}

void AboutDialogImpl::setAckText()
{
   QString text = "<html>";

   text += tr("With special thanks to:");
   text += "<br><br>";
   text += tr("<b>Jan</b> and <b>Kai Schmidt</b>");
   text += "<br>";
   text += tr("<b>Dave Knopp</b>");
   text += "<br>";
   text += tr("<b>Peter Palfrader</b>, <b>Jason Friedrich</b> and <b>Frank Lichtenheld</b> for maintaining of the debian package");
   text += "<br>";
   text += tr("<b>Soeren Staun-Pedersen</b> for hosting of the LinCVS mailing list at SunSITE.dk");
   text += "<br>";
   text += tr("<b>Iztok Kobal</b> for qt backward compatibility patches");
   text += "<br>";
   text += tr("<b>Raimar Lamprecht</b>, <b>Kelly John Carney</b> and <b>Will Stokes</b> for support of Mac OS X port");
   text += "<br>";
   text += tr("<b>Andre Oliveira da Costa</b> and <b>Dag Wieers</b> for maintaining of RPM packages for Fedora/RedHat");
   text += "<br>";
   text += tr("<b>Robert Hess</b> for the old logo icon");
   text += "<br><br>";
   text += tr("Thanks to the people behind <b>Trolltech</b> for a very powerful toolkit and excellent support");
   text += "<br><br>";
   text += tr("Thanks to many people for hints, bug reports, bug fixes, etc.");

   text += "</html>";

   m_pAckText->setText(text);
}

void AboutDialogImpl::setLicenseText()
{
   QString text = "<html>";

   text += tr("LinCVS is available under two different licenses:");
   text += "<br><br>";
   text += tr("If LinCVS is linked against the GPLed version of Qt LinCVS is released under the terms of <b>GPL</b> also. If LinCVS is linked against a nonGPLed version of Qt LinCVS is released under the terms of the LinCVS License for non-Unix platforms (<b>LLNU</b>).");
   text += "<br><br><br>";
   text += tr("LinCVS License for non-Unix platforms (<b>LLNU</b>):");
   text += "<br><br>";
   text += tr("Redistribution and use in binary form, without modification, are permitted provided that the following conditions are met:");
   text += "<br><ol><li>";
   text += tr("Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.");
   text += "</li><li>";
   text += tr("It is not permitted to distribute the binary package under a name different than LinCVS.");
   text += "</li><li>";
   text += tr("The name of the authors may not be used to endorse or promote products derived from this software without specific prior written permission.");
   text += "</li><li>";
   text += tr("The source code is the creative property of the authors. Extensions and development under the terms of the Gnu Public License are limited to the Unix platform. Any distribution or compilation of the source code against libraries licensed other than <b>GPL</b> requires the written permission of the authors.");
   text += "</li></ol><br>";
   text += tr("THIS SOFTWARE IS PROVIDED BY THE AUTHOR \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.");
   text += "<br><br><br><br>";
   text += tr("LinCVS License for <b>Unix</b> platforms:");
   text += "<br><br>";
   text += tr("This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your  option) any later version.  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.");
   text += "<br><br>";
   text += tr("See the <b>GNU General Public License</b> for more details.");
   
   text += "</html>";
   
   m_pLicenseText->setText(text);
}
