/****************************************************************************
 **
 ** Copyright (C) 1999-2005 Tilo Riemer <riemer@lincvs.org>,
 **                         Frank Hemer <frank@hemer.org>
 **
 **
 **----------------------------------------------------------------------------
 **
 **----------------------------------------------------------------------------
 **
 ** LinCVS is available under two different licenses:
 **
 ** If LinCVS is linked against the GPLed version of Qt 
 ** LinCVS is released under the terms of GPL also.
 **
 ** If LinCVS is linked against a nonGPLed version of Qt 
 ** LinCVS is released under the terms of the 
 ** LinCVS License for non-Unix platforms (LLNU)
 **
 **
 ** LinCVS License for non-Unix platforms (LLNU):
 **
 ** Redistribution and use in binary form, without modification, 
 ** are permitted provided that the following conditions are met:
 **
 ** 1. Redistributions in binary form must reproduce the above copyright
 **    notice, this list of conditions and the following disclaimer in the
 **    documentation and/or other materials provided with the distribution.
 ** 2. It is not permitted to distribute the binary package under a name
 **    different than LinCVS.
 ** 3. The name of the authors may not be used to endorse or promote
 **    products derived from this software without specific prior written
 **    permission.
 ** 4. The source code is the creative property of the authors.
 **    Extensions and development under the terms of the Gnu Public License
 **    are limited to the Unix platform. Any distribution or compilation of 
 **    the source code against libraries licensed other than gpl requires 
 **    the written permission of the authors.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
 ** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 ** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 ** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 ** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 ** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 ** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 ** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 **
 **
 ** LinCVS License for Unix platforms:
 **
 ** This program is free software; you can redistribute it and/or modify 
 ** it under the terms of the GNU General Public License as published by 
 ** the Free Software Foundation; either version 2 of the License, or 
 ** (at your  option) any later version.  This program is distributed in 
 ** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 ** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 ** PARTICULAR PURPOSE.
 **
 ** See the GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **
 *****************************************************************************/

#include <qtimer.h>
#include <qpainter.h>
#include <qcommonstyle.h>
#include <qapplication.h>
#include <qdrawutil.h>

//----------------------------------------------------------------------------

#include "ColorButton.h"

//----------------------------------------------------------------------------

CColorButton::CColorButton(QWidget * parent, const char * name)
   : QPushButton(parent, name), m_color(Qt::black)
{
   setText(QString::null);
}

//----------------------------------------------------------------------------

CColorButton::CColorButton(const QColor &color, QWidget * parent, const char * name)
   : QPushButton(parent, name), m_color(color)
{
   setText(QString::null);
}

//----------------------------------------------------------------------------

void CColorButton::setColor(const QColor &color)
{
   m_color = color;
   update();
}

//----------------------------------------------------------------------------

QSize CColorButton::sizeHint() const {
   return style().sizeFromContents(QStyle::CT_PushButton, this, QSize(35,35) ).expandedTo( QApplication::globalStrut() );
}

//----------------------------------------------------------------------------

void CColorButton::drawButtonLabel(QPainter * p)
{
   int x, y, w, h;
   QRect r = style().subRect(QStyle::SR_PushButtonContents, this);
   r.rect(&x, &y, &w, &h);
   
   int margin = style().pixelMetric(QStyle::PM_ButtonMargin, this);
   x += margin;
   y += margin;
   w -= 2*margin;
   h -= 2*margin;
   
   if (isOn() || isDown()) {
      x += style().pixelMetric(QStyle::PM_ButtonShiftHorizontal, this);
      y += style().pixelMetric(QStyle::PM_ButtonShiftVertical, this);
   }
   
   QColor color = isEnabled() ? m_color : backgroundColor();
   qDrawShadePanel(p, x, y, w, h, colorGroup(), true, 1, NULL);
   if (color.isValid()) {
#ifdef Q_WS_MAC
      QBrush old(p->brush());
      p->setBrush(color);
      p->drawChord(x+1, y+1, w-2, h-2, 0, 5760);
      p->setBrush(old);
#else
      p->fillRect(x+1, y+1, w-2, h-2, color);
#endif
   }
   
   if (hasFocus()) {
      QRect focusRect = style().subRect(QStyle::SR_PushButtonFocusRect, this);
      style().drawPrimitive(QStyle::PE_FocusRect, p, focusRect, colorGroup());
   }
}

//----------------------------------------------------------------------------
