/****************************************************************************
 **
 ** Copyright (C) 2001-2004 Tilo Riemer <riemer@lincvs.org> and
 **                         Frank Hemer <frank@hemer.org>
 **
 **
 **----------------------------------------------------------------------------
 **
 **----------------------------------------------------------------------------
 **
 ** LinCVS is available under two different licenses:
 **
 ** If LinCVS is linked against the GPLed version of Qt 
 ** LinCVS is released under the terms of GPL also.
 **
 ** If LinCVS is linked against a nonGPLed version of Qt 
 ** LinCVS is released under the terms of the 
 ** LinCVS License for non-Unix platforms (LLNU)
 **
 **
 ** LinCVS License for non-Unix platforms (LLNU):
 **
 ** Redistribution and use in binary form, without modification, 
 ** are permitted provided that the following conditions are met:
 **
 ** 1. Redistributions in binary form must reproduce the above copyright
 **    notice, this list of conditions and the following disclaimer in the
 **    documentation and/or other materials provided with the distribution.
 ** 2. It is not permitted to distribute the binary package under a name
 **    different than LinCVS.
 ** 3. The name of the authors may not be used to endorse or promote
 **    products derived from this software without specific prior written
 **    permission.
 ** 4. The source code is the creative property of the authors.
 **    Extensions and development under the terms of the Gnu Public License
 **    are limited to the Unix platform. Any distribution or compilation of 
 **    the source code against libraries licensed other than gpl requires 
 **    the written permission of the authors.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
 ** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 ** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 ** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 ** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 ** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 ** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 ** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 **
 **
 ** LinCVS License for Unix platforms:
 **
 ** This program is free software; you can redistribute it and/or modify 
 ** it under the terms of the GNU General Public License as published by 
 ** the Free Software Foundation; either version 2 of the License, or 
 ** (at your  option) any later version.  This program is distributed in 
 ** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 ** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 ** PARTICULAR PURPOSE.
 **
 ** See the GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **
 *****************************************************************************/

#ifndef SYNTAXHIGHLIGHTER_H_20030704
#define SYNTAXHIGHLIGHTER_H_20030704

//----------------------------------------------------------------------------

#include "config.h"

//----------------------------------------------------------------------------

namespace SyntaxHighlighter {
   enum HighlightMode {
      HM_NONE = 0,     //no highlight
      HM_UPDATE,       //used for (query) update
      HM_DIFF,         //used for diff to console
      HM_DIFFSBS,      //used for diff side-by-side
      HM_STATUS,       //used for status
      HM_LOGIN         //used for login/out
   };

   enum HighlightState {//cvs status produces paragraph spanning constructs
      HS_NONE         = 0,    //no highlight, not inside in a paragraph spanning construct
      HS_UPTODATE     = 1,    //inside a uptodate block
      HS_MODIFIED     = 2,    //inside a modified block
      HS_NEEDS_UPDATE = 3,    //inside a needs update block
      HS_NEEDS_MERGE  = 4,    //inside a needs merge block
      HS_CONFLICT     = 5,    //inside a conflict block
      HS_ADDED        = 6,    //inside a added block
      HS_REMOVED      = 7     //inside a removed block
   };
};

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

#if QT_VERSION > 0x030020

//----------------------------------------------------------------------------

namespace SyntaxHighlighter {
   const bool AVAILABLE = true;
};

//----------------------------------------------------------------------------

#include <qstring.h>
#include <qtextedit.h>

//----------------------------------------------------------------------------

class CSyntaxHighlighter
{
 public:
   CSyntaxHighlighter() : m_mode(SyntaxHighlighter::HM_NONE) {}

   int highlightLine(QString &,int);

   /**
      Sets the currently used mode (update, diff, ...).
   */
   void setMode(SyntaxHighlighter::HighlightMode mode);

   
 private:

   int highlightParagraph(QString & text, int endStateOfLastPara);

   /**
      Syntax highlighting for update commands
   */
   int update(QString & text, int endStateOfLastPara);

   /**
      Syntax highlighting for diff side-by-side
   */
   int diffSideBySide(QString & text, int endStateOfLastPara);

   /**
      Syntax highlighting for diff to console
   */
   int diff(QString & text, int endStateOfLastPara);

   /**
      Syntax highlighting for status
   */
   int status(QString & text, int endStateOfLastPara);

   /**
      Syntax highlighting for login/out
   */
   int login(QString & text, int endStateOfLastPara);

   /**
      Sets the format accordingly to the passed property, start position
      inside the paragraph and count of affected characters.
   */
   int setHighlightFormat(QString &, HighlightProperties::Properties prop,
	 int start, int count);

   QString getHexCol(const QColor &);

   int replaceTags(QString &,int=0,int=-1);

   SyntaxHighlighter::HighlightMode m_mode;
};

//----------------------------------------------------------------------------

#endif   //QT_VERSION > 0x030020

#endif   //SYNTAXHIGHLIGHTER_H_20030704
