/****************************************************************************
**
** Copyright (C) 2001-2004 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Frank Hemer <frank@hemer.at>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Tom Mishima <tmishima@mail.at-m.or.jp>
**    Joerg Preiss <auba@auba.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/


#include "config.h"

//----------------------------------------------------------------------------

#include <qlabel.h>
#include <qevent.h>
#include <qcheckbox.h>
#include <qwhatsthis.h>
#include <qpushbutton.h>

//----------------------------------------------------------------------------

#include "globals.h"
#include "GrabKeyboardImpl.h"

//----------------------------------------------------------------------------

GrabKeyboardImpl::GrabKeyboardImpl(const QIconSet &whatsThisIconSet,
				   QWidget * parent,int oldAccel) 
  : GrabKeyboard(parent,0,TRUE,0), m_blocked(FALSE), m_keySeq(NULL) 
{
  m_pWhatsThis->setIconSet(whatsThisIconSet);
#ifdef Q_WS_MAC
  m_pWhatsThis->setMaximumWidth(m_pWhatsThis->height() * 2);
#else
  m_pWhatsThis->setMaximumWidth(m_pWhatsThis->height());
#endif

  PrevKey->setText( QString(QKeySequence(oldAccel)) );
}

//----------------------------------------------------------------------------

GrabKeyboardImpl::~GrabKeyboardImpl() {
  delete m_keySeq;
  m_keySeq = NULL;
}

//----------------------------------------------------------------------------

void GrabKeyboardImpl::keyPressEvent ( QKeyEvent * e) {

  bool done = FALSE;
  QString txt;
  int state;
  int modifier = 0;

  state = e->state();
  if (state & Qt::NoButton) {
    txt += "";
  }
  if (state & Qt::ShiftButton) {
    txt += "SHIFT ";
    modifier |= SHIFT;
  }
  if (state & Qt::ControlButton) {
    txt += "CONTROL ";
    modifier |= CTRL;
  }
  if (state & Qt::MetaButton) {
    txt += "META ";
#if QT_VERSION < 0x030100
    modifier |= 0x00100000;
#else
    modifier |= META;
#endif
  }
  if (state & Qt::AltButton) {
    txt += "ALT ";
    modifier |= ALT;
  }

  if (e->key() == Qt::Key_Shift) {
    m_blocked = FALSE;
    if ( !(state & Qt::ShiftButton)) txt += "SHIFT ";
  } else if (e->key() == Key_Control) {
    m_blocked = FALSE;
    if ( !(state & Qt::ControlButton)) txt += "CONTROL ";
  } else if (e->key() == Key_Meta) {
    m_blocked = FALSE;
    if ( !(state & Qt::MetaButton)) txt += "META ";
  } else if (e->key() == Key_Alt) {
    m_blocked = FALSE;
    if ( !(state & Qt::AltButton)) txt += "ALT ";
  } else {
    txt += QChar(e->key());
    delete m_keySeq;
    m_keySeq = new QKeySequence(modifier | e->key());
    if (!KeepOpenBox->isChecked()) done = TRUE;
    m_blocked = TRUE;
  }
  NewKey->setText(txt);

  e->accept();
  
  if (done) accept();
}

//----------------------------------------------------------------------------

void GrabKeyboardImpl::keyReleaseEvent ( QKeyEvent * e) {
  if (!m_blocked) {
    NewKey->setText("");
    delete m_keySeq;
    m_keySeq = NULL;
  }
  e->accept();
}

//----------------------------------------------------------------------------

QKeySequence GrabKeyboardImpl::getKeySequence() {
  if (m_keySeq) {
    return QKeySequence(*m_keySeq);
  } else {
    return QKeySequence();
  }
}

//----------------------------------------------------------------------------

void GrabKeyboardImpl::enterWhatsThisMode()
{
   QWhatsThis::enterWhatsThisMode();
}

//----------------------------------------------------------------------------
