/* 
 * defs.h
 * Copyright (C) 2002, AVM GmbH. All rights reserved.
 * 
 * This Software is  free software. You can redistribute and/or
 * modify such free software under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * The free software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this Software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA, or see
 * http://www.opensource.org/licenses/lgpl-license.html
 * 
 * Contact: AVM GmbH, Alt-Moabit 95, 10559 Berlin, Germany, email: info@avm.de
 */

#ifndef __have_defs_h__
#define __have_defs_h__

#ifndef LINUX_VERSION_CODE
# include <linux/version.h>
#endif

#ifndef TRUE
# define TRUE	(1==1)
# define FALSE	(1==0)
#endif

#if !defined(SA_SHIRQ)
#define SA_SHIRQ IRQF_SHARED
#endif
#if !defined(SA_INTERRUPT)
#define SA_INTERRUPT IRQF_DISABLED
#endif

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#if   defined (__fcdslslusb__)
# define USB_PRODUCT_ID_FCDSLSLUSB	0x3500
# define PRODUCT_LOGO			"AVM FRITZ!Card DSL SL USB"
#elif defined (__fcdslusba__)
# define USB_PRODUCT_ID_FCDSLUSBA	0x3000
# define PRODUCT_LOGO			"AVM FRITZ!Card DSL USB analog"
#elif defined (__fcdslusb2__)
# define USB_PRODUCT_ID_FCDSLUSB2	0x3600
# define PRODUCT_LOGO			"AVM FRITZ!Card DSL USB v2.0"
# define DRIVER_TYPE_ISDN
#else
# error Card specifier missing!
#endif
#define INTERFACE			"usb"

#define	VENDOR_ID_AVM			0x057C

#define SHORT_LOGO			TARGET "-" INTERFACE
#define DRIVER_LOGO			PRODUCT_LOGO " driver"
#define DRIVER_TYPE_DSL
#define DRIVER_TYPE_DSL_RAP
#define DRIVER_TYPE_USB
#define	DRIVER_REV			"0.4.4"

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#if defined (OSDEBUG) && defined (NDEBUG)
# undef NDEBUG
#endif

#define	UNUSED_ARG(x)	(x)=(x)

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#define	TOOLS_MEM_DUMP

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#endif

