/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.management.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.logging.Log;
import org.apache.hivemind.ErrorHandler;
import org.apache.hivemind.events.RegistryShutdownListener;
import org.apache.hivemind.internal.ServicePoint;
import org.apache.hivemind.management.MBeanRegistry;
import org.apache.hivemind.management.ManagementMessages;
import org.apache.hivemind.management.ObjectNameBuilder;
import org.apache.hivemind.management.impl.MBeanRegistrationContribution;

public class MBeanRegistryImpl
implements MBeanRegistry,
RegistryShutdownListener {
    private ErrorHandler _errorHandler;
    private Log _log;
    private MBeanServer _beanServer;
    private ObjectNameBuilder _objectNameBuilder;
    private List _beans;
    private List _objectInstances = new ArrayList();
    static /* synthetic */ Class class$javax$management$DynamicMBean;

    public MBeanRegistryImpl(ErrorHandler errorHandler, Log log, MBeanServer beanServer, ObjectNameBuilder objectNameBuilder, List beans) {
        this._errorHandler = errorHandler;
        this._log = log;
        this._beanServer = beanServer;
        this._objectNameBuilder = objectNameBuilder;
        this._beans = beans;
        if (this._beans != null) {
            this.processContributions(this._beans);
        }
    }

    private void processContributions(List beans) {
        Iterator iter = beans.iterator();
        while (iter.hasNext()) {
            MBeanRegistrationContribution mbeanReg = (MBeanRegistrationContribution)iter.next();
            this.registerServiceAsMBean(mbeanReg.getObjectName(), mbeanReg.getServicePoint(), mbeanReg.getStartMethod());
        }
    }

    private void registerServiceAsMBean(ObjectName objectName, ServicePoint servicePoint, String startMethodName) {
        Object mbean;
        if (objectName == null) {
            objectName = this._objectNameBuilder.createServiceObjectName(servicePoint);
        }
        try {
            Class managementInterface = servicePoint.getServiceInterface();
            mbean = servicePoint.getService(managementInterface);
            this.registerMBean(mbean, managementInterface, objectName);
        }
        catch (JMException e) {
            this._errorHandler.error(this._log, ManagementMessages.errorRegisteringMBean(objectName, e), null, (Throwable)e);
            return;
        }
        try {
            if (startMethodName != null) {
                this.invokeStartMethod(mbean, startMethodName);
            }
        }
        catch (InvocationTargetException e) {
            this._errorHandler.error(this._log, ManagementMessages.errorStartMethodFailed(startMethodName, objectName, e.getTargetException()), null, (Throwable)e);
            return;
        }
        catch (Exception e) {
            this._errorHandler.error(this._log, ManagementMessages.errorStartMethodFailed(startMethodName, objectName, e), null, (Throwable)e);
            return;
        }
    }

    public ObjectInstance registerMBean(Object obj, Class managementInterface, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectInstance instance = null;
        try {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Trying to register MBean " + objectName));
            }
            instance = this._beanServer.registerMBean(obj, objectName);
        }
        catch (NotCompliantMBeanException e) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("MBean " + objectName + " is not compliant. Registering" + " using StandardMBean"));
            }
            if ((class$javax$management$DynamicMBean == null ? (class$javax$management$DynamicMBean = MBeanRegistryImpl.class$("javax.management.DynamicMBean")) : class$javax$management$DynamicMBean).isAssignableFrom(obj.getClass()) || managementInterface == null) {
                throw e;
            }
            StandardMBean standardMBean = new StandardMBean(obj, managementInterface);
            instance = this._beanServer.registerMBean(standardMBean, objectName);
        }
        this._objectInstances.add(instance);
        return instance;
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        ObjectInstance instance = this._beanServer.getObjectInstance(objectName);
        this._objectInstances.remove(instance);
        this._beanServer.unregisterMBean(objectName);
    }

    private void invokeStartMethod(Object mbean, String methodName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> serviceClass = mbean.getClass();
        Method m = serviceClass.getMethod(methodName, null);
        m.invoke(mbean, null);
    }

    public void registryDidShutdown() {
        for (int i = this._objectInstances.size() - 1; i >= 0; --i) {
            ObjectInstance objectInstance = (ObjectInstance)this._objectInstances.get(i);
            try {
                this._beanServer.unregisterMBean(objectInstance.getObjectName());
                continue;
            }
            catch (JMException e) {
                this._log.warn((Object)ManagementMessages.errorUnregisteringMBean(objectInstance.getObjectName(), e));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

