/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.impl.servicemodel;

import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Discardable;
import org.apache.hivemind.ShutdownCoordinator;
import org.apache.hivemind.events.RegistryShutdownListener;
import org.apache.hivemind.impl.ConstructableServicePoint;
import org.apache.hivemind.impl.ProxyUtils;
import org.apache.hivemind.impl.servicemodel.AbstractServiceModelImpl;
import org.apache.hivemind.impl.servicemodel.ServiceModelMessages;
import org.apache.hivemind.internal.Module;
import org.apache.hivemind.service.ThreadCleanupListener;
import org.apache.hivemind.service.ThreadEventNotifier;

public final class ThreadedServiceModel
extends AbstractServiceModelImpl {
    protected static final String SERVICE_ACCESSOR_METHOD_NAME = "_service";
    private Object _serviceProxy;
    private ThreadEventNotifier _notifier;
    private Class _serviceInterface;
    private ThreadLocal _activeService;
    static /* synthetic */ Class class$org$apache$hivemind$service$ThreadEventNotifier;

    public ThreadedServiceModel(ConstructableServicePoint servicePoint) {
        super(servicePoint);
        this._serviceInterface = servicePoint.getServiceInterface();
    }

    public synchronized Object getService() {
        if (this._activeService == null) {
            this._activeService = new ThreadLocal();
            Module module = this.getServicePoint().getModule();
            this._notifier = (ThreadEventNotifier)module.getService("hivemind.ThreadEventNotifier", class$org$apache$hivemind$service$ThreadEventNotifier == null ? (class$org$apache$hivemind$service$ThreadEventNotifier = ThreadedServiceModel.class$("org.apache.hivemind.service.ThreadEventNotifier")) : class$org$apache$hivemind$service$ThreadEventNotifier);
            this._serviceProxy = this.createServiceProxy();
        }
        return this._serviceProxy;
    }

    private Object createServiceProxy() {
        ConstructableServicePoint servicePoint = this.getServicePoint();
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Creating ThreadedProxy for service " + servicePoint.getExtensionPointId()));
        }
        Object proxy = ProxyUtils.createDelegatingProxy("ThreadedProxy", this, "getServiceImplementationForCurrentThread", servicePoint);
        Object intercepted = this.addInterceptors(proxy);
        RegistryShutdownListener outerProxy = ProxyUtils.createOuterProxy(intercepted, servicePoint);
        ShutdownCoordinator coordinator = servicePoint.getShutdownCoordinator();
        coordinator.addRegistryShutdownListener(outerProxy);
        return outerProxy;
    }

    public Object getServiceImplementationForCurrentThread() {
        Object result = this._activeService.get();
        if (result == null) {
            result = this.constructServiceForCurrentThread();
        }
        return result;
    }

    private synchronized Object constructServiceForCurrentThread() {
        try {
            Object core = this.constructCoreServiceImplementation();
            if (core instanceof RegistryShutdownListener) {
                this._log.error((Object)ServiceModelMessages.registryCleanupIgnored(this.getServicePoint()));
            }
            this._notifier.addThreadCleanupListener(new CleanupListener(core));
            if (!this._serviceInterface.isInstance(core)) {
                core = this.constructBridgeProxy(core);
            }
            this._activeService.set(core);
            return core;
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ServiceModelMessages.unableToConstructService(this.getServicePoint(), ex), ex);
        }
    }

    private void unbindServiceFromCurrentThread() {
        this._activeService.set(null);
    }

    public void instantiateService() {
        this.getServiceImplementationForCurrentThread();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class CleanupListener
    implements ThreadCleanupListener {
        private Object _core;

        CleanupListener(Object core) {
            this._core = core;
        }

        public void threadDidCleanup() {
            ThreadedServiceModel.this._notifier.removeThreadCleanupListener(this);
            ThreadedServiceModel.this.unbindServiceFromCurrentThread();
            if (this._core instanceof Discardable) {
                Discardable d = (Discardable)this._core;
                d.threadDidDiscardService();
            }
        }
    }
}

