/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.service.impl;

import javassist.CtClass;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.service.ClassFab;
import org.apache.hivemind.service.ClassFactory;
import org.apache.hivemind.service.InterfaceFab;
import org.apache.hivemind.service.impl.ClassFabImpl;
import org.apache.hivemind.service.impl.CtClassSource;
import org.apache.hivemind.service.impl.HiveMindClassPool;
import org.apache.hivemind.service.impl.InterfaceFabImpl;
import org.apache.hivemind.service.impl.ServiceMessages;

public class ClassFactoryImpl
implements ClassFactory {
    private HiveMindClassPool _pool = new HiveMindClassPool();
    private CtClassSource _classSource = new CtClassSource(this._pool);

    public ClassFab newClass(String name, Class superClass) {
        try {
            CtClass ctNewClass = this._classSource.newClass(name, superClass);
            return new ClassFabImpl(this._classSource, ctNewClass);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ServiceMessages.unableToCreateClass(name, superClass, ex), ex);
        }
    }

    public InterfaceFab newInterface(String name) {
        try {
            CtClass ctNewClass = this._classSource.newInterface(name);
            return new InterfaceFabImpl(this._classSource, ctNewClass);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ServiceMessages.unableToCreateInterface(name, ex), ex);
        }
    }
}

